/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe.instrument.io.grinding;

import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import sirttas.elementalcraft.recipe.RecipeHelper;
import sirttas.elementalcraft.recipe.instrument.io.grinding.IGrindingRecipe;

public class AirMillGrindingRecipe
implements IGrindingRecipe {
    @ObjectHolder(value="elementalcraft:grinding")
    public static final IRecipeSerializer<AirMillGrindingRecipe> SERIALIZER = null;
    private final Ingredient ingredient;
    private final ItemStack output;
    private final int elementAmount;
    private final ResourceLocation id;

    protected AirMillGrindingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int elementAmount) {
        this.id = id;
        this.ingredient = ingredient;
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Override
    public int getElementAmount() {
        return this.elementAmount;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.ingredient});
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AirMillGrindingRecipe> {
        public AirMillGrindingRecipe read(ResourceLocation recipeId, JsonObject json) {
            int elementAmount = JSONUtils.func_151203_m((JsonObject)json, (String)"element_amount");
            Ingredient ingredient = RecipeHelper.deserializeIngredient(json, "input");
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            if (!output.func_190926_b()) {
                return new AirMillGrindingRecipe(recipeId, ingredient, output, elementAmount);
            }
            return null;
        }

        public AirMillGrindingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int elementAmount = buffer.readInt();
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack output = buffer.func_150791_c();
            return new AirMillGrindingRecipe(recipeId, ingredient, output, elementAmount);
        }

        public void write(PacketBuffer buffer, AirMillGrindingRecipe recipe) {
            buffer.writeInt(recipe.getElementAmount());
            ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buffer);
            buffer.func_150788_a(recipe.func_77571_b());
        }
    }
}

