/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.properties;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.codec.Codecs;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.gui.ECColorHelper;
import sirttas.elementalcraft.spell.Spell;

@Mod.EventBusSubscriber(modid="elementalcraft")
public class SpellProperties
implements IElementTypeProvider {
    public static final String NAME = "spell_properties";
    public static final String FOLDER = "elementalcraft_spell_properties";
    public static final SpellProperties NONE = new SpellProperties();
    public static final Codec<SpellProperties> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Spell.Type.CODEC.fieldOf("spell_type").forGetter(SpellProperties::getSpellType), ElementType.forGetter(SpellProperties::getElementType), (App)Codec.INT.optionalFieldOf("weight", (Object)0).forGetter(SpellProperties::getWeight), (App)Codec.INT.optionalFieldOf("use_duration", (Object)0).forGetter(SpellProperties::getUseDuration), (App)Codec.INT.optionalFieldOf("element_consumption", (Object)0).forGetter(SpellProperties::getConsumeAmount), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(SpellProperties::getCooldown), (App)Codec.FLOAT.optionalFieldOf("range", (Object)Float.valueOf(0.0f)).forGetter(SpellProperties::getRange), (App)Codecs.COLOR.optionalFieldOf("color", (Object)-1).forGetter(SpellProperties::getColor)).apply((Applicative)builder, SpellProperties::new));
    private int cooldown;
    private int consumeAmount;
    private int useDuration;
    private int weight;
    private int color;
    private float range;
    private ElementType elementType;
    private Spell.Type spellType;

    public SpellProperties() {
        this(Spell.Type.NONE, ElementType.NONE, 0, 0, 0, 0, 0.0f, -1);
    }

    private SpellProperties(Spell.Type spellType, ElementType elementType, int weight, int useDuration, int consumeAmount, int cooldown, float range, int color) {
        this.spellType = spellType;
        this.elementType = elementType;
        this.weight = weight;
        this.useDuration = useDuration;
        this.consumeAmount = consumeAmount;
        this.cooldown = cooldown;
        this.range = range;
        this.color = color;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getConsumeAmount() {
        return this.consumeAmount;
    }

    public int getUseDuration() {
        return this.useDuration;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    public Spell.Type getSpellType() {
        return this.spellType;
    }

    public float getRange() {
        return this.range;
    }

    public int getColor() {
        return this.color;
    }

    @SubscribeEvent
    public static void onReload(DataManagerReloadEvent<SpellProperties> event) {
        Map data = event.getDataManager().getData();
        for (Spell spell : Spell.REGISTRY.getValues()) {
            SpellProperties prop = (SpellProperties)data.get(spell.getRegistryName());
            if (prop != null) {
                spell.setProperties(prop);
                continue;
            }
            spell.setProperties(NONE);
        }
    }

    public static final class Builder {
        public static final Encoder<Builder> ENCODER = CodecHelper.remapField(CODEC, (MapEncoder)Codecs.HEX_COLOR.fieldOf("color"), p -> SpellProperties.access$100(p)).comap(builder -> new SpellProperties(builder.type, builder.elementType, builder.weight, builder.useDuration, builder.consumeAmount, builder.cooldown, (float)builder.range, builder.color));
        private int cooldown;
        private int consumeAmount;
        private int useDuration;
        private int weight;
        private int color;
        private double range;
        private ElementType elementType;
        private final Spell.Type type;

        private Builder(Spell.Type type) {
            this.type = type;
            this.elementType = ElementType.NONE;
            this.cooldown = 0;
            this.consumeAmount = 0;
            this.useDuration = 0;
            this.weight = 0;
        }

        public static Builder create(Spell.Type type) {
            return new Builder(type);
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder consumeAmount(int consumeAmount) {
            this.consumeAmount = consumeAmount;
            return this;
        }

        public Builder useDuration(int useDuration) {
            this.useDuration = useDuration;
            return this;
        }

        public Builder elementType(ElementType elementType) {
            this.elementType = elementType;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder range(double range) {
            this.range = range;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder color(int r, int g, int b) {
            return this.color(ECColorHelper.packColor(r, g, b));
        }

        public JsonElement toJson() {
            return CodecHelper.encode(ENCODER, (Object)this);
        }
    }
}

