/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.CapabilityElementStorage;
import sirttas.elementalcraft.api.element.storage.EmptyElementStorage;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.StaticElementStorage;

public class WorldElementStorage
implements IElementStorage {
    private final SubStorage fire;
    private final SubStorage water;
    private final SubStorage earth;
    private final SubStorage air;

    private WorldElementStorage() {
        this(new SubStorage(ElementType.FIRE), new SubStorage(ElementType.WATER), new SubStorage(ElementType.EARTH), new SubStorage(ElementType.AIR));
    }

    private WorldElementStorage(SubStorage fire, SubStorage water, SubStorage earth, SubStorage air) {
        this.fire = fire;
        this.water = water;
        this.earth = earth;
        this.air = air;
    }

    public static ICapabilityProvider createProvider() {
        return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY != null ? new CapabilityProvider(new WorldElementStorage()) : null;
    }

    @Override
    public int getElementAmount(ElementType type) {
        return this.getSubStorage(type).getElementAmount(type);
    }

    @Override
    public int getElementCapacity(ElementType type) {
        return this.getSubStorage(type).getElementCapacity(type);
    }

    @Override
    public int insertElement(int count, ElementType type, boolean simulate) {
        return this.getSubStorage(type).insertElement(count, type, simulate);
    }

    @Override
    public int extractElement(int count, ElementType type, boolean simulate) {
        return this.getSubStorage(type).extractElement(count, type, simulate);
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(ElementType.FIRE.func_176610_l(), (INBT)this.fire.writeNBT());
        compound.func_218657_a(ElementType.WATER.func_176610_l(), (INBT)this.water.writeNBT());
        compound.func_218657_a(ElementType.EARTH.func_176610_l(), (INBT)this.earth.writeNBT());
        compound.func_218657_a(ElementType.AIR.func_176610_l(), (INBT)this.air.writeNBT());
        return compound;
    }

    public void readNBT(CompoundNBT compound) {
        this.fire.readNBT(compound.func_74775_l(ElementType.FIRE.func_176610_l()));
        this.water.readNBT(compound.func_74775_l(ElementType.WATER.func_176610_l()));
        this.earth.readNBT(compound.func_74775_l(ElementType.EARTH.func_176610_l()));
        this.air.readNBT(compound.func_74775_l(ElementType.AIR.func_176610_l()));
    }

    private IElementStorage getSubStorage(ElementType elementType) {
        switch (elementType) {
            case FIRE: {
                return this.fire;
            }
            case AIR: {
                return this.air;
            }
            case EARTH: {
                return this.earth;
            }
            case WATER: {
                return this.water;
            }
        }
        return EmptyElementStorage.INSTANCE;
    }

    private static class CapabilityProvider
    implements ICapabilitySerializable<CompoundNBT> {
        private final WorldElementStorage storage;

        public CapabilityProvider(WorldElementStorage storage) {
            this.storage = storage;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CapabilityElementStorage.ELEMENT_STORAGE_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.storage));
        }

        public CompoundNBT serializeNBT() {
            return this.storage.writeNBT();
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.storage.readNBT(nbt);
        }
    }

    private static class SubStorage
    extends StaticElementStorage {
        public SubStorage(ElementType type, int elementAmount, int elementCapacity) {
            super(type, elementCapacity);
            this.elementAmount = elementAmount;
        }

        public SubStorage(ElementType type) {
            super(type, 1000000);
        }
    }
}

