/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.world.feature.structure;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.world.feature.config.IElementTypeFeatureConfig;
import sirttas.elementalcraft.world.feature.structure.ECStructures;

public class SourceAltarStructure
extends Structure<IElementTypeFeatureConfig> {
    public static final String NAME = "source_altar";

    public SourceAltarStructure() {
        super(IElementTypeFeatureConfig.CODEC);
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<IElementTypeFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "elementalcraft:source_altar";
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation templateName;
        private ElementType elementType;

        public Piece(TemplateManager templateManager, ResourceLocation templateName, ElementType elementType, BlockPos pos) {
            super(ECStructures.SOURCE_ALTAR_PIECE_TYPE, 0);
            this.field_186178_c = pos;
            this.templateName = templateName;
            this.elementType = elementType;
            this.initTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbt) {
            super(ECStructures.SOURCE_ALTAR_PIECE_TYPE, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.elementType = ElementType.byName(nbt.func_74779_i("ElementType"));
            this.initTemplate(templateManager);
        }

        private void initTemplate(TemplateManager templateManager) {
            this.func_186173_a(templateManager.func_200220_a(this.templateName), this.field_186178_c, new PlacementSettings().func_186214_a(Mirror.NONE).func_207665_a(new BlockPos(1, 0, 1)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
            tagCompound.func_74778_a("ElementType", this.elementType.func_176610_l());
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn, BlockPos pos) {
            this.field_186178_c = this.field_186178_c.func_177982_a(0, worldIn.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.field_186178_c.func_177958_n(), this.field_186178_c.func_177952_p()) - 1, 0);
            return super.func_230383_a_(worldIn, structureManager, chunkGeneratorIn, randomIn, mutableBoundingBoxIn, chunkPosIn, pos);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if (function.endsWith("chest")) {
                this.func_191080_a(worldIn, sbb, rand, pos, ElementalCraft.createRL("chests/altar/" + this.getChestType(function) + '_' + this.elementType.func_176610_l()), null);
                worldIn.func_230547_a_(pos, Blocks.field_150486_ae);
            } else if ("source".equals(function)) {
                worldIn.func_180501_a(pos, (BlockState)ECBlocks.SOURCE.func_176223_P().func_206870_a(ElementType.STATE_PROPERTY, (Comparable)((Object)this.elementType)), 3);
            }
        }

        private String getChestType(String function) {
            String[] split = function.split("_");
            return split.length > 1 ? split[0] : "small";
        }
    }

    public static class Start
    extends StructureStart<IElementTypeFeatureConfig> {
        public Start(Structure<IElementTypeFeatureConfig> structure, int x, int y, MutableBoundingBox mutableBoundingBox, int k, long l) {
            super(structure, x, y, mutableBoundingBox, k, l);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistries, ChunkGenerator generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, IElementTypeFeatureConfig config) {
            this.field_75075_a.add(new Piece(templateManagerIn, this.getRoll(), config.getElementType((Random)this.field_214631_d), new BlockPos(chunkX * 16, 0, chunkZ * 16)));
            this.func_202500_a();
        }

        private ResourceLocation getRoll() {
            int roll = this.field_214631_d.nextInt(20);
            if (roll == 0) {
                return ElementalCraft.createRL("altar/chapel");
            }
            if (roll <= 3) {
                return ElementalCraft.createRL("altar/medium");
            }
            return ElementalCraft.createRL("altar/small");
        }
    }
}

