/*
 * Decompiled with CFR 0.152.
 */
package com.cgt.evolvedrpg.entity;

import com.cgt.evolvedrpg.EvolvedRpgModElements;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

@EvolvedRpgModElements.ModElement.Tag
public class DesertGolemEntity
extends EvolvedRpgModElements.ModElement {
    public static EntityType entity = null;

    public DesertGolemEntity(EvolvedRpgModElements instance) {
        super(instance, 1);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.8f, 1.875f).func_206830_a("desert_golem").setRegistryName("desert_golem");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -13210, -9805758, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("desert_golem_spawn_egg"));
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        boolean biomeCriteria = false;
        if (new ResourceLocation("desert").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("desert_hills").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (new ResourceLocation("desert_lakes").equals((Object)event.getName())) {
            biomeCriteria = true;
        }
        if (!biomeCriteria) {
            return;
        }
        event.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners(entity, 65, 1, 2));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)entity, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223324_d);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.2);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 35.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 6.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 5.0);
        ammma = ammma.func_233815_a_(Attributes.field_233820_c_, 0.5);
        ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 1.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta) {
        DesertGolemEntity.addBoxHelper(renderer, texU, texV, x, y, z, dx, dy, dz, delta, renderer.field_78809_i);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBoxHelper(ModelRenderer renderer, int texU, int texV, float x, float y, float z, int dx, int dy, int dz, float delta, boolean mirror) {
        renderer.field_78809_i = mirror;
        renderer.func_217178_a("", x, y, z, dx, dy, dz, delta, texU, texV);
    }

    public static class Modelgolem_desert
    extends EntityModel {
        private final ModelRenderer root;
        private final ModelRenderer body;
        private final ModelRenderer head;
        private final ModelRenderer left_leg;
        private final ModelRenderer right_leg;
        private final ModelRenderer right_arm;
        private final ModelRenderer left_arm;

        public Modelgolem_desert() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.root = new ModelRenderer((Model)this);
            this.root.func_78793_a(0.0f, 24.0f, 0.0f);
            this.body = new ModelRenderer((Model)this);
            this.body.func_78793_a(0.0f, -14.0f, 0.0f);
            this.root.func_78792_a(this.body);
            DesertGolemEntity.addBoxHelper(this.body, 32, 21, -5.0f, -5.0f, -3.0f, 10, 5, 6, 0.3f, false);
            DesertGolemEntity.addBoxHelper(this.body, 0, 0, -8.0f, -15.0f, -5.0f, 16, 10, 9, 0.2f, false);
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, -29.0f, -3.0f);
            this.root.func_78792_a(this.head);
            DesertGolemEntity.addBoxHelper(this.head, 0, 24, -4.5f, -7.0f, -7.0f, 9, 10, 9, 0.0f, false);
            this.left_leg = new ModelRenderer((Model)this);
            this.left_leg.func_78793_a(3.0f, -13.0f, 0.0f);
            this.root.func_78792_a(this.left_leg);
            DesertGolemEntity.addBoxHelper(this.left_leg, 0, 44, -3.0f, -1.0f, -3.0f, 6, 14, 6, 0.0f, false);
            this.right_leg = new ModelRenderer((Model)this);
            this.right_leg.func_78793_a(-3.0f, -13.0f, 0.0f);
            this.root.func_78792_a(this.right_leg);
            DesertGolemEntity.addBoxHelper(this.right_leg, 0, 44, -3.0f, -1.0f, -3.0f, 6, 14, 6, 0.0f, false);
            this.right_arm = new ModelRenderer((Model)this);
            this.right_arm.func_78793_a(-9.0f, -26.0f, 0.0f);
            this.root.func_78792_a(this.right_arm);
            DesertGolemEntity.addBoxHelper(this.right_arm, 36, 37, -6.0f, -3.0f, -4.0f, 7, 20, 7, 0.0f, false);
            this.left_arm = new ModelRenderer((Model)this);
            this.left_arm.func_78793_a(9.0f, -26.0f, 0.0f);
            this.root.func_78792_a(this.left_arm);
            DesertGolemEntity.addBoxHelper(this.left_arm, 36, 37, -1.0f, -3.0f, -4.0f, 7, 20, 7, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            this.root.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.head.field_78796_g = f3 / 57.295776f;
            this.head.field_78795_f = f4 / 57.295776f;
            this.left_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.right_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.right_leg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
            this.left_arm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 7;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, true));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ServerPlayerEntity.class, true, true));
            this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(5, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(7, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Blocks.field_150322_A, 1));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sand.break")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.hit"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(""));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof PotionEntity) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new Modelgolem_desert(), 1.0f){

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("evolved_rpg:textures/desertgolem.png");
                }
            });
        }
    }
}

