/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.container;

import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.pavocado.exoticbirds.container.FunctionalIntReferenceHolder;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsContainers;
import net.pavocado.exoticbirds.tileentity.TileEntityIncubator;

public class ContainerIncubator
extends Container {
    public final TileEntityIncubator tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public ContainerIncubator(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, ContainerIncubator.getTileEntity(playerInventory, data));
    }

    public ContainerIncubator(int windowId, PlayerInventory playerInventory, TileEntityIncubator tileEntity) {
        super((ContainerType)ExoticBirdsContainers.EGG_INCUBATOR.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.func_216958_a(new FunctionalIntReferenceHolder(() -> tileEntity.eggIncubateTime, v -> {
            tileEntity.eggIncubateTime = v;
        }));
        this.func_216958_a(new FunctionalIntReferenceHolder(() -> tileEntity.fuelBurnTimeLeft, v -> {
            tileEntity.fuelBurnTimeLeft = v;
        }));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 0, 80, 59));
        for (int row = 0; row < 2; ++row) {
            for (int column2 = 0; column2 < 7; ++column2) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileEntity.inventory, 1 + row * 7 + column2, 26 + column2 * 18, 17 + row * 18));
            }
        }
        int playerInventoryStartX = 8;
        int playerInventoryStartY = 88;
        int slotBuffer = 18;
        for (int row = 0; row < 3; ++row) {
            for (column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, 9 + row * 9 + column, playerInventoryStartX + column * slotBuffer, playerInventoryStartY + row * slotBuffer));
            }
        }
        int playerHotbarY = playerInventoryStartY + slotBuffer * 3 + 4;
        for (column = 0; column < 9; ++column) {
            this.func_75146_a(new Slot((IInventory)playerInventory, column, playerInventoryStartX + column * slotBuffer, playerHotbarY));
        }
    }

    private static TileEntityIncubator getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        TileEntity tileEntity = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileEntity instanceof TileEntityIncubator) {
            return (TileEntityIncubator)tileEntity;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileEntity);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack returnStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            returnStack = slotStack.func_77946_l();
            int containerSlots = this.field_75151_b.size() - player.field_71071_by.field_70462_a.size();
            if (index < containerSlots ? !this.func_75135_a(slotStack, containerSlots, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, containerSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == returnStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return returnStack;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return ContainerIncubator.func_216963_a((IWorldPosCallable)this.canInteractWithCallable, (PlayerEntity)player, (Block)((Block)ExoticBirdsBlocks.EGG_INCUBATOR.get()));
    }
}

