/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.tileentity.TileEntityBirdcage;

public class PacketLogBirdcage {
    private final BlockPos cagePos;
    private final boolean isNewEntry;

    public PacketLogBirdcage(BlockPos cagePos, boolean isNewEntry) {
        this.cagePos = cagePos;
        this.isNewEntry = isNewEntry;
    }

    public static void encode(PacketLogBirdcage message, PacketBuffer buffer) {
        buffer.func_179255_a(message.cagePos);
        buffer.writeBoolean(message.isNewEntry);
    }

    public static PacketLogBirdcage decode(PacketBuffer buffer) {
        return new PacketLogBirdcage(buffer.func_179259_c(), buffer.readBoolean());
    }

    public static void handle(PacketLogBirdcage packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketLogBirdcage.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogBirdcage packet) {
        Entity entity;
        TileEntity tileEntity;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (tileEntity = player.field_70170_p.func_175625_s(packet.cagePos)) instanceof TileEntityBirdcage && (entity = ((TileEntityBirdcage)tileEntity).getBirdcageLogic().getCachedEntity()) instanceof EntityAbstractBird) {
            EntityAbstractBird birdEntity = (EntityAbstractBird)entity;
            String variantName = birdEntity.func_200200_C_().getString();
            if (packet.isNewEntry) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_new", new Object[]{variantName.toLowerCase()}).func_240699_a_(TextFormatting.AQUA), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_old", new Object[]{variantName}).func_240699_a_(TextFormatting.GRAY), Util.field_240973_b_);
            }
            String speciesName = birdEntity.getTranslatedVariantName(birdEntity.getVariant(), false);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("book.exoticbirds.log_species", new Object[]{speciesName}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC), Util.field_240973_b_);
        }
    }
}

