/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.BlockIdentifier;
import net.pavocado.exoticbirds.container.ContainerIdentifier;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsTileEntities;
import net.pavocado.exoticbirds.item.ItemBirdEgg;

public class TileEntityIdentifier
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public ItemStackHandler inventory = new ItemStackHandler(17){

        public int getSlotLimit(int slot) {
            if (slot == 0 || slot == 1) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            switch (slot) {
                case 0: {
                    return !stack.func_190926_b() && stack.func_77973_b() == ExoticBirdsItems.MYSTERY_EGG.get();
                }
                case 1: {
                    return TileEntityIdentifier.this.getBurnTime(stack) > 0;
                }
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityIdentifier.this.func_70296_d();
        }
    };
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalUp = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 2, 17));
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalSides = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 2));
    public int eggIncubateTime = -1;
    public int fuelBurnTimeLeft = -1;
    public int maxFuelBurnTime = -1;
    private boolean lastBurning = false;

    public TileEntityIdentifier() {
        super((TileEntityType)ExoticBirdsTileEntities.EGG_IDENTIFIER.get());
    }

    public boolean isBurning() {
        return this.fuelBurnTimeLeft > 0;
    }

    public int getBurnTime(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item == Items.field_151137_ax) {
                return 200;
            }
            if (item == Items.field_221858_em) {
                return 1800;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        boolean hasFuel = false;
        if (this.isBurning()) {
            hasFuel = true;
            --this.fuelBurnTimeLeft;
        }
        if (this.canSmelt()) {
            if (!hasFuel && this.burnFuel()) {
                hasFuel = true;
            }
            if (hasFuel) {
                if (this.eggIncubateTime == -1) {
                    this.eggIncubateTime = 200;
                } else {
                    --this.eggIncubateTime;
                    if (this.eggIncubateTime == 0) {
                        this.smeltItem();
                        this.eggIncubateTime = -1;
                    }
                }
            } else if (this.eggIncubateTime < 200) {
                this.eggIncubateTime = MathHelper.func_76125_a((int)(this.eggIncubateTime + 2), (int)0, (int)200);
            }
        } else {
            this.eggIncubateTime = -1;
        }
        if (this.lastBurning != hasFuel) {
            this.func_70296_d();
            BlockState newState = (BlockState)this.func_195044_w().func_206870_a((Property)BlockIdentifier.field_220091_b, (Comparable)Boolean.valueOf(hasFuel));
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
            this.lastBurning = hasFuel;
        }
    }

    private boolean canSmelt() {
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            for (int i = 2; i < 17; ++i) {
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public void smeltItem() {
        ItemStack result;
        ItemStack identifyStack = this.inventory.getStackInSlot(0).func_77946_l();
        identifyStack.func_190918_g(1);
        this.inventory.setStackInSlot(0, identifyStack);
        if (new Random().nextInt(3) == 0) {
            result = new ItemStack((IItemProvider)ExoticBirdsItems.EGGSHELL.get(), new Random().nextInt(3) + 1);
        } else {
            List<Item> eggList = ExoticBirdsItems.getEggList();
            result = new ItemStack((IItemProvider)eggList.get(new Random().nextInt(eggList.size())), 1);
            if (result.func_77973_b() instanceof ItemBirdEgg) {
                CompoundNBT compoundnbt = result.func_190925_c("eggValues");
                compoundnbt.func_74768_a("SpawnChance", 50 + (int)(Math.log(Math.random() + 1.0) * 4.0) * 10);
                ((ItemBirdEgg)result.func_77973_b()).setEggVariant(result, this.field_145850_b);
            }
        }
        for (int i = 2; i < 17; ++i) {
            ItemStack eggStack = this.inventory.getStackInSlot(i);
            if (!eggStack.func_190926_b()) continue;
            this.inventory.setStackInSlot(i, result);
            break;
        }
    }

    private boolean burnFuel() {
        ItemStack fuelStack = this.inventory.getStackInSlot(1).func_77946_l();
        if (!fuelStack.func_190926_b()) {
            this.maxFuelBurnTime = this.fuelBurnTimeLeft = this.getBurnTime(fuelStack);
            if (fuelStack.hasContainerItem()) {
                this.inventory.setStackInSlot(1, fuelStack.getContainerItem());
            } else {
                fuelStack.func_190918_g(1);
                this.inventory.setStackInSlot(1, fuelStack);
            }
            return true;
        }
        this.fuelBurnTimeLeft = -1;
        this.maxFuelBurnTime = -1;
        return false;
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.lastBurning = this.isBurning();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.eggIncubateTime = compound.func_74762_e("incubateTime");
        this.fuelBurnTimeLeft = compound.func_74762_e("fuelBurnTimeLeft");
        this.maxFuelBurnTime = compound.func_74762_e("maxFuelBurnTime");
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("incubateTime", this.eggIncubateTime);
        compound.func_74768_a("fuelBurnTimeLeft", this.fuelBurnTimeLeft);
        compound.func_74768_a("maxFuelBurnTime", this.maxFuelBurnTime);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((BlockIdentifier)ExoticBirdsBlocks.EGG_IDENTIFIER.get()).func_149739_a());
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerIdentifier(windowId, inventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
                case UP: {
                    return this.inventoryCapabilityExternalUp.cast();
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    return this.inventoryCapabilityExternalSides.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternalUp.invalidate();
        this.inventoryCapabilityExternalDown.invalidate();
        this.inventoryCapabilityExternalSides.invalidate();
    }
}

