/*
 * Decompiled with CFR 0.152.
 */
package com.blackout.extendedslabs.core;

import com.blackout.extendedslabs.api.block.ModCorners;
import com.blackout.extendedslabs.api.block.ModSlabs;
import com.blackout.extendedslabs.api.block.ModStairs;
import com.blackout.extendedslabs.api.block.ModVerticalSlabs;
import com.blackout.extendedslabs.core.ClientProxy;
import com.blackout.extendedslabs.core.CommonProxy;
import com.blackout.extendedslabs.render.block.BlockRenderLayer;
import com.blackout.extendedslabs.util.CreativeTab;
import java.util.Optional;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="extendedslabs")
public class ExtendedSlabs {
    public static final String MODID = "extendedslabs";
    public static final String MODNAME = "Extended Slabs";
    public static final String VERSION = "1.4.0";
    public static ExtendedSlabs INSTANCE;
    public static CommonProxy PROXY;
    public static final Logger LOGGER;
    public static final ItemGroup GROUP;

    public ExtendedSlabs() {
        INSTANCE = this;
        if (ModList.get().isLoaded("biomesoplenty")) {
            ModVerticalSlabs.registerBOPCompat();
        }
        if (ModList.get().isLoaded("biomesoplenty")) {
            ModCorners.registerBOPCompat();
        }
        if (ModList.get().isLoaded("biomesoplenty")) {
            LOGGER.debug("extendedslabs: Biomes O' Plenty Compat Loaded");
        }
        if (ModList.get().isLoaded("michrosia")) {
            ModVerticalSlabs.registerMichrosiaCompat();
        }
        if (ModList.get().isLoaded("michrosia")) {
            ModCorners.registerMichrosiaCompat();
        }
        if (ModList.get().isLoaded("michrosia")) {
            LOGGER.debug("extendedslabs: Michrosia Compat Loaded");
        }
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCorners.ITEMS.register(eventBus);
        ModCorners.BLOCKS.register(eventBus);
        ModSlabs.ITEMS.register(eventBus);
        ModSlabs.BLOCKS.register(eventBus);
        ModStairs.ITEMS.register(eventBus);
        ModStairs.BLOCKS.register(eventBus);
        ModVerticalSlabs.ITEMS.register(eventBus);
        ModVerticalSlabs.BLOCKS.register(eventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::OnLoadComplete);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BlockRenderLayer.renderBlock();
        LOGGER.info("renderBlock");
    }

    private void OnLoadComplete(FMLLoadCompleteEvent event) {
        PROXY.init();
    }

    public static String getVersion(boolean correctInDev) {
        Optional o = ModList.get().getModContainerById(MODID);
        if (o.isPresent()) {
            String str = ((ModContainer)o.get()).getModInfo().getVersion().toString();
            if (correctInDev && "NONE".equals(str)) {
                return VERSION;
            }
            return str;
        }
        return "0.0.0";
    }

    public static boolean isDevBuild() {
        return "NONE".equals(ExtendedSlabs.getVersion(false));
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MODID, name);
    }

    static {
        PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        LOGGER = LogManager.getLogger((String)MODID);
        GROUP = new CreativeTab();
    }
}

