/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;

public class ConfigCache {
    private static ConfigCache INSTANCE;
    private Set<class_1792> toolsBlacklist;
    private Set<class_1792> toolsWhitelist;
    private Set<class_2248> leavesBlacklist;
    private Set<class_2248> logsBlacklist;
    private Set<class_2248> leavesWhitelist;
    private Set<class_2248> leavesNonDecayWhitelist;
    private Set<class_2248> logsWhitelist;
    private Set<class_2248> adjacentBlocksWhitelist;
    private Set<class_2248> adjacentBlocksBase;

    public void invalidate() {
        this.toolsBlacklist = null;
        this.toolsWhitelist = null;
        this.leavesBlacklist = null;
        this.leavesWhitelist = null;
        this.leavesNonDecayWhitelist = null;
        this.logsBlacklist = null;
        this.logsWhitelist = null;
        this.adjacentBlocksWhitelist = null;
        this.adjacentBlocksBase = null;
    }

    public Collection<class_1792> getToolsWhitelisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsWhitelist)) {
            this.toolsWhitelist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsWhitelist;
    }

    public Collection<class_1792> getToolsBlacklisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsBlacklist)) {
            this.toolsBlacklist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsBlacklist;
    }

    public Collection<class_2248> getBlacklistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesBlacklist)) {
            this.leavesBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesBlacklist;
    }

    public Collection<class_2248> getBlacklistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsBlacklist)) {
            this.logsBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsBlacklist;
    }

    public Collection<class_2248> getWhitelistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesWhitelist)) {
            this.leavesWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesWhitelist;
    }

    public Collection<class_2248> getWhitelistedAdjacentBlocks(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.adjacentBlocksWhitelist)) {
            this.adjacentBlocksWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.adjacentBlocksWhitelist;
    }

    public Collection<class_2248> getAdjacentBlocksBase() {
        if (Objects.isNull(this.adjacentBlocksBase)) {
            this.adjacentBlocksBase = new HashSet<class_2248>();
            this.adjacentBlocksBase.add(class_2246.field_10124);
            this.adjacentBlocksBase.addAll(class_3481.field_15503.method_15138());
            this.adjacentBlocksBase.addAll(class_3481.field_15475.method_15138());
            this.adjacentBlocksBase.addAll(this.getWhitelistedLogs(FallingTree.config.getTrees()::getWhitelistedLogs));
            this.adjacentBlocksBase.addAll(this.getWhitelistedLeaves(FallingTree.config.getTrees()::getWhitelistedLeaves));
            this.adjacentBlocksBase.addAll(this.getWhitelistedNonDecayLeaves(FallingTree.config.getTrees()::getWhitelistedNonDecayLeaves));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLogs(FallingTree.config.getTrees()::getBlacklistedLogs));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLeaves(FallingTree.config.getTrees()::getBlacklistedLeaves));
        }
        return this.adjacentBlocksBase;
    }

    public Collection<class_2248> getWhitelistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsWhitelist)) {
            this.logsWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsWhitelist;
    }

    public Collection<class_2248> getWhitelistedNonDecayLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesNonDecayWhitelist)) {
            this.leavesNonDecayWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesNonDecayWhitelist;
    }

    public static ConfigCache getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ConfigCache();
        }
        return INSTANCE;
    }
}

