/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.NotificationMode;
import fr.raksrinana.fallingtree.fabric.config.ToolConfiguration;
import fr.raksrinana.fallingtree.fabric.config.TreeConfiguration;
import fr.raksrinana.fallingtree.fabric.config.validator.Validators;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1269;

@Config(name="fallingtree")
public class Configuration
implements ConfigData {
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, a tree will only be chopped down if the player is sneaking.")
    public boolean reverseSneaking = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, the mod will cut down trees in creative too.")
    public boolean breakInCreative = false;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="How messages are sent to the player. \nCHAT: Messages are sent in the chat. \nACTION_BAR: Messages are displayed in the player's action bar.")
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public NotificationMode notificationMode = NotificationMode.ACTION_BAR;
    @ConfigEntry.Category(value="trees")
    @ConfigEntry.Gui.TransitiveObject
    public TreeConfiguration trees = new TreeConfiguration();
    @ConfigEntry.Category(value="tools")
    @ConfigEntry.Gui.TransitiveObject
    public ToolConfiguration tools = new ToolConfiguration();

    public static Configuration register() {
        ConfigHolder configHolder = AutoConfig.register(Configuration.class, JanksonConfigSerializer::new);
        configHolder.registerSaveListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        configHolder.registerLoadListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        return (Configuration)configHolder.getConfig();
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        Validators.runValidators(Configuration.class, this, "general");
        Validators.runValidators(ToolConfiguration.class, this.tools, "tools");
        Validators.runValidators(TreeConfiguration.class, this.trees, "trees");
    }

    public boolean isReverseSneaking() {
        return this.reverseSneaking;
    }

    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    public NotificationMode getNotificationMode() {
        return this.notificationMode;
    }

    public TreeConfiguration getTrees() {
        return this.trees;
    }

    public ToolConfiguration getTools() {
        return this.tools;
    }
}

