/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.config;

import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.validator.ItemId;
import fr.raksrinana.fallingtree.fabric.config.validator.Min;
import fr.raksrinana.fallingtree.fabric.config.validator.MinMax;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1792;

public class ToolConfiguration {
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="Additional list of tools that can be used to chop down a tree. \nINFO: Items marked with the axe tag will already be whitelisted.")
    @ItemId
    public List<String> whitelisted = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="List of tools that should not be considered as tools. \nINFO: This wins over the whitelist.")
    @ItemId
    public List<String> blacklisted = new ArrayList<String>();
    @ConfigEntry.Gui.Tooltip(count=3)
    @Comment(value="When set to true, when a tree is broken and the tool is about to break we will just break enough blocks so that the tool is left at 1 of durability.\nINFO: Only in instantaneous mode")
    public boolean preserve = false;
    @ConfigEntry.Gui.Tooltip(count=4)
    @Comment(value="When set to true, the mod will be activated no matter what you have in your hand. \nINFO: Blacklist still can be use to restrict some tools.")
    public boolean ignoreTools = false;
    @ConfigEntry.Gui.Tooltip(count=7)
    @Comment(value="Defines the number of times the damage is applied to the tool. \nie: if set to 1 then breaking 5 logs will give 5 damage. \nie: if set to 2 then breaking 5 logs will give 10 damage. \nIf set to 0, it'll still apply 1 damage for every cut. \nINFO: This only applies when the tree is cut when using the mod.")
    @Min(value=0)
    public int damageMultiplicand = 1;
    @ConfigEntry.Gui.Tooltip(count=15)
    @Comment(value="Applies a speed modifier when breaking the tree. \n0 will disable this, so the speed will be the default one of breaking a block. \nIf set to 1 each log block will be counted once, so if the tree is 5 blocks tall it'll require the time of breaking 5 logs. \nIf set to 2 each log block will be counted twice, so if the tree is 5 blocks tall, it'll require the time of breaking 10 logs. \nINFO: Only in INSTANTANEOUS mode. \nWARNING: If you are on a server, this either has to be set to 0 or every player should have the mod. Else they'll have a weird effect of breaking the block but the block is still there.")
    @MinMax(min=0, max=50)
    public double speedMultiplicand = 0.0;

    public Collection<class_1792> getBlacklistedItems() {
        return ConfigCache.getInstance().getToolsBlacklisted(this::getBlacklisted);
    }

    public Collection<class_1792> getWhitelistedItems() {
        return ConfigCache.getInstance().getToolsWhitelisted(this::getWhitelisted);
    }

    public List<String> getWhitelisted() {
        return this.whitelisted;
    }

    public List<String> getBlacklisted() {
        return this.blacklisted;
    }

    public boolean isPreserve() {
        return this.preserve;
    }

    public boolean isIgnoreTools() {
        return this.ignoreTools;
    }

    public int getDamageMultiplicand() {
        return this.damageMultiplicand;
    }

    public double getSpeedMultiplicand() {
        return this.speedMultiplicand;
    }
}

