/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.builder;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.fabric.config.ConfigCache;
import fr.raksrinana.fallingtree.fabric.config.DetectionMode;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.builder.AbortSearchException;
import fr.raksrinana.fallingtree.fabric.tree.builder.AdjacentAbortSearchException;
import fr.raksrinana.fallingtree.fabric.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.fabric.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.AbovePositionFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.AboveYFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.fabric.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.fabric.utils.TreePartType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4970;

public class TreeBuilder {
    private static final EnumSet<class_2350> ALL_DIRECTIONS = EnumSet.allOf(class_2350.class);

    public static Optional<Tree> getTree(class_1657 player, class_1937 level, class_2338 originPos) throws TreeTooBigException {
        class_2248 originBlock = level.method_8320(originPos).method_26204();
        if (!FallingTreeUtils.isLogBlock(originBlock)) {
            return Optional.empty();
        }
        int maxScanSize = FallingTree.config.getTrees().getMaxScanSize();
        PriorityQueue<ToAnalyzePos> toAnalyzePos = new PriorityQueue<ToAnalyzePos>();
        HashSet<ToAnalyzePos> analyzedPos = new HashSet<ToAnalyzePos>();
        Tree tree = new Tree(level, originPos);
        toAnalyzePos.add(new ToAnalyzePos(TreeBuilder.getFirstPositionFetcher(), originPos, originBlock, originPos, originBlock, TreePartType.LOG, 0));
        Predicate<class_2338> boundingBoxSearch = TreeBuilder.getBoundingBoxSearch(originPos);
        Predicate<class_2248> adjacentPredicate = TreeBuilder.getAdjacentPredicate();
        try {
            TreeBuilder.checkAdjacent(adjacentPredicate, level, originPos);
            while (!toAnalyzePos.isEmpty()) {
                ToAnalyzePos analyzingPos = (ToAnalyzePos)toAnalyzePos.remove();
                tree.addPart(analyzingPos.toTreePart());
                analyzedPos.add(analyzingPos);
                if (tree.getSize() > maxScanSize) {
                    FallingTree.logger.info("Tree at {} reached max scan size of {}", (Object)tree.getHitPos(), (Object)maxScanSize);
                    throw new TreeTooBigException();
                }
                Collection<ToAnalyzePos> potentialPositions = analyzingPos.positionFetcher().getPositions(level, originPos, analyzingPos);
                Collection<ToAnalyzePos> nextPositions = TreeBuilder.filterPotentialPos(boundingBoxSearch, adjacentPredicate, level, originPos, originBlock, analyzingPos, potentialPositions, analyzedPos);
                nextPositions.removeAll(analyzedPos);
                nextPositions.removeAll(toAnalyzePos);
                toAnalyzePos.addAll(nextPositions);
            }
            TreeBuilder.postProcess(tree);
        }
        catch (AbortSearchException e) {
            FallingTree.logger.info("Didn't cut tree at {}, reason: {}", (Object)originPos, (Object)e.getMessage());
            FallingTreeUtils.notifyPlayer(player, (class_2561)new class_2588("chat.fallingtree.search_aborted").method_10852(e.getComponent()));
            return Optional.empty();
        }
        if (FallingTree.config.getTrees().getBreakMode().isCheckLeavesAround()) {
            int aroundRequired = FallingTree.config.getTrees().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeBuilder.getLeavesAround(level, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                FallingTree.logger.info("Tree at {} doesn't have enough leaves around top most log", (Object)originPos);
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static void postProcess(Tree tree) {
        tree.getTopMostLog().ifPresent(topMostLog -> tree.removePartsHigherThan(topMostLog.method_10264() + 1, TreePartType.NETHER_WART));
    }

    private static Predicate<class_2248> getAdjacentPredicate() {
        Collection<class_2248> whitelist = FallingTree.config.getTrees().getWhitelistedAdjacentBlockBLocks();
        Collection<class_2248> base = ConfigCache.getInstance().getAdjacentBlocksBase();
        if (whitelist.isEmpty()) {
            return block -> true;
        }
        return switch (FallingTree.config.getTrees().getAdjacentStopMode()) {
            case AdjacentStopMode.STOP_ALL -> block -> {
                boolean whitelisted;
                boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                if (!whitelisted) {
                    throw new AdjacentAbortSearchException((class_2248)block);
                }
                return true;
            };
            case AdjacentStopMode.STOP_BRANCH -> block -> {
                boolean whitelisted;
                boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                if (!whitelisted) {
                    FallingTree.logger.info("Found block {} that isn't whitelisted in the adjacent blocks, branch will be ignored further", block);
                    return false;
                }
                return true;
            };
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static Predicate<class_2338> getBoundingBoxSearch(class_2338 originPos) {
        int radius = FallingTree.config.getTrees().getSearchAreaRadius();
        if (radius < 0) {
            return pos -> true;
        }
        int minX = originPos.method_10263() - radius;
        int maxX = originPos.method_10263() + radius;
        int minZ = originPos.method_10260() - radius;
        int maxZ = originPos.method_10260() + radius;
        return pos -> minX <= pos.method_10263() && maxX >= pos.method_10263() && minZ <= pos.method_10260() && maxZ >= pos.method_10260();
    }

    private static IPositionFetcher getFirstPositionFetcher() {
        DetectionMode detectionMode = FallingTree.config.getTrees().getDetectionMode();
        return switch (detectionMode) {
            case DetectionMode.ABOVE_CUT -> AbovePositionFetcher.getInstance();
            case DetectionMode.ABOVE_Y -> AboveYFetcher.getInstance();
            case DetectionMode.WHOLE_TREE -> BasicPositionFetcher.getInstance();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static Collection<ToAnalyzePos> filterPotentialPos(Predicate<class_2338> boundingBoxSearch, Predicate<class_2248> adjacentPredicate, class_1937 level, class_2338 originPos, class_2248 originBlock, ToAnalyzePos parent, Collection<ToAnalyzePos> potentialPos, Collection<ToAnalyzePos> analyzedPos) {
        return potentialPos.stream().filter(pos -> !analyzedPos.contains(pos)).filter(pos -> TreeBuilder.shouldIncludeInChain(boundingBoxSearch, originPos, originBlock, parent, pos)).filter(pos -> TreeBuilder.checkAdjacent(adjacentPredicate, level, pos.checkPos())).collect(Collectors.toList());
    }

    private static boolean checkAdjacent(Predicate<class_2248> adjacentPredicate, class_1937 level, class_2338 pos) {
        return EnumSet.allOf(class_2350.class).stream().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)level).method_8320(arg_0)).map(class_4970.class_4971::method_26204).allMatch(adjacentPredicate);
    }

    private static long getLeavesAround(class_1937 world, class_2338 blockPos) {
        return ALL_DIRECTIONS.stream().map(arg_0 -> ((class_2338)blockPos).method_10093(arg_0)).filter(testPos -> {
            class_2248 block = world.method_8320(testPos).method_26204();
            return FallingTreeUtils.isLeafBlock(block) || FallingTreeUtils.isNetherWartOrShroomlight(block) || FallingTreeUtils.isLeafNeedBreakBlock(block);
        }).count();
    }

    private static boolean shouldIncludeInChain(Predicate<class_2338> boundingBoxSearch, class_2338 originPos, class_2248 originBlock, ToAnalyzePos parent, ToAnalyzePos check) {
        if (parent.treePartType() == TreePartType.LOG && TreeBuilder.isSameTree(originBlock, check) && boundingBoxSearch.test(check.checkPos())) {
            return true;
        }
        if (FallingTree.config.getTrees().isBreakNetherTreeWarts() && check.treePartType() == TreePartType.NETHER_WART) {
            class_2338 checkBlockPos = check.checkPos();
            int dx = Math.abs(originPos.method_10263() - checkBlockPos.method_10263());
            int dz = Math.abs(originPos.method_10260() - checkBlockPos.method_10260());
            return dx <= 4 && dz <= 4;
        }
        return check.treePartType() == TreePartType.LEAF_NEED_BREAK;
    }

    private static boolean isSameTree(class_2248 parentLogBlock, ToAnalyzePos check) {
        if (FallingTree.config.getTrees().isAllowMixedLogs()) {
            return check.treePartType() == TreePartType.LOG;
        }
        return check.checkBlock().equals(parentLogBlock);
    }
}

