/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.utils;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.ToolConfiguration;
import fr.raksrinana.fallingtree.fabric.utils.TreePartType;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.tag.TagRegistry;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;

public class FallingTreeUtils {
    public static Set<class_1792> getAsItems(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getItem).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Stream<class_1792> getItem(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                return TagRegistry.item((class_2960)identifier).method_15138().stream();
            }
            return Stream.of((class_1792)class_2378.field_11142.method_10223(identifier));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static Set<class_2248> getAsBlocks(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getBlock).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Stream<class_2248> getBlock(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            class_2960 identifier = new class_2960(name);
            if (isTag) {
                return TagRegistry.block((class_2960)identifier).method_15138().stream();
            }
            return Stream.of((class_2248)class_2378.field_11146.method_10223(identifier));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static boolean isLeafBlock(class_2248 block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = class_3481.field_15503.method_15141((Object)block) || FallingTree.config.getTrees().getWhitelistedLeaveBlocks().stream().anyMatch(leaf -> leaf.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = FallingTree.config.getTrees().getBlacklistedLeaveBlocks().stream().anyMatch(leaf -> leaf.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean canPlayerBreakTree(class_1657 player) {
        boolean isWhitelistedTool;
        ToolConfiguration toolConfiguration = FallingTree.config.getTools();
        class_1792 heldItem = player.method_6047().method_7909();
        boolean bl = isWhitelistedTool = toolConfiguration.isIgnoreTools() || FabricToolTags.AXES.method_15141((Object)heldItem) || toolConfiguration.getWhitelistedItems().stream().anyMatch(tool -> tool.equals(heldItem));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = toolConfiguration.getBlacklistedItems().stream().anyMatch(tool -> tool.equals(heldItem));
            return !isBlacklistedTool;
        }
        return false;
    }

    public static TreePartType getTreePart(class_2248 checkBlock) {
        if (FallingTreeUtils.isLogBlock(checkBlock)) {
            return TreePartType.LOG;
        }
        if (FallingTreeUtils.isNetherWartOrShroomlight(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (FallingTreeUtils.isLeafNeedBreakBlock(checkBlock)) {
            return TreePartType.LEAF_NEED_BREAK;
        }
        if (FallingTreeUtils.isLeafBlock(checkBlock)) {
            return TreePartType.LEAF;
        }
        return TreePartType.OTHER;
    }

    public static boolean isLeafNeedBreakBlock(class_2248 block) {
        return FallingTree.config.getTrees().getWhitelistedNonDecayLeaveBlocks().stream().anyMatch(log -> log.equals(block));
    }

    public static boolean isPlayerInRightState(class_1657 player) {
        if (player.method_7337() && !FallingTree.config.isBreakInCreative()) {
            return false;
        }
        if (FallingTree.config.isReverseSneaking() != player.method_18276()) {
            return false;
        }
        return FallingTreeUtils.canPlayerBreakTree(player);
    }

    public static boolean isLogBlock(class_2248 block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = class_3481.field_15475.method_15141((Object)block) || FallingTree.config.getTrees().getWhitelistedLogBlocks().stream().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = FallingTree.config.getTrees().getBlacklistedLogBlocks().stream().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isNetherWartOrShroomlight(class_2248 block) {
        return class_3481.field_21954.method_15141((Object)block) || block.equals(class_2246.field_22122);
    }

    public static void notifyPlayer(class_1657 player, class_2561 text) {
        class_1657 class_16572 = player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            switch (FallingTree.config.getNotificationMode()) {
                case CHAT: {
                    player.method_9203(text, class_156.field_25140);
                    break;
                }
                case ACTION_BAR: {
                    serverPlayer.method_14254(text, class_2556.field_11733, class_156.field_25140);
                }
            }
        } else {
            player.method_9203(text, class_156.field_25140);
        }
    }
}

