/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.breaking;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.TreePart;
import fr.raksrinana.fallingtree.fabric.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ToolDamageHandler;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    private static InstantaneousTreeBreakingHandler INSTANCE;

    @Override
    public boolean breakTree(class_1657 player, Tree tree) throws BreakTreeTooBigException {
        return this.destroyInstant(tree, player, player.method_6047());
    }

    private boolean destroyInstant(Tree tree, class_1657 player, class_1799 tool) throws BreakTreeTooBigException {
        class_1937 level = tree.getLevel();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, FallingTree.config.getTools().getDamageMultiplicand(), FallingTree.config.getTools().isPreserve(), tree.getBreakableCount());
        if (toolHandler.getMaxBreakCount() <= 0) {
            FallingTree.logger.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            FallingTreeUtils.notifyPlayer(player, (class_2561)new class_2588("chat.fallingtree.prevented_break_tool"));
            return false;
        }
        int brokenCount = tree.getBreakableParts().stream().sorted(FallingTree.config.getTrees().getBreakOrder().getComparator()).limit(toolHandler.getMaxBreakCount()).map(TreePart::blockPos).mapToInt(logBlockPos -> {
            class_2680 logState = level.method_8320(logBlockPos);
            logState.method_26204().method_9556(level, player, logBlockPos, logState, level.method_8321(logBlockPos), tool);
            level.method_8650(logBlockPos, false);
            return 1;
        }).sum();
        int toolDamage = toolHandler.getActualDamage(brokenCount) - 1;
        if (toolDamage > 0) {
            tool.method_7956(toolDamage, (class_1309)player, entity -> {});
        }
        if (brokenCount >= toolHandler.getMaxBreakCount()) {
            this.forceBreakDecayLeaves(tree, level);
        }
        return true;
    }

    private void forceBreakDecayLeaves(Tree tree, class_1937 level) {
        int radius = FallingTree.config.getTrees().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                class_2338.class_2339 checkPos = new class_2338.class_2339();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.method_10103(topLog.method_10263() + dx, topLog.method_10264() + dy, topLog.method_10260() + dz);
                            class_2680 checkState = level.method_8320((class_2338)checkPos);
                            class_2248 checkBlock = checkState.method_26204();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            class_2248.method_9497((class_2680)checkState, (class_1937)level, (class_2338)checkPos);
                            level.method_8650((class_2338)checkPos, false);
                        }
                    }
                }
            });
        }
    }

    public static InstantaneousTreeBreakingHandler getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new InstantaneousTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

