/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.breaking;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.tree.Tree;
import fr.raksrinana.fallingtree.fabric.tree.TreePart;
import fr.raksrinana.fallingtree.fabric.tree.breaking.BreakTreeTooBigException;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.fabric.tree.breaking.ToolDamageHandler;
import fr.raksrinana.fallingtree.fabric.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.fabric.utils.TreePartType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class ShiftDownTreeBreakingHandler
implements ITreeBreakingHandler {
    private static ShiftDownTreeBreakingHandler INSTANCE;

    @Override
    public boolean breakTree(class_1657 player, Tree tree) throws BreakTreeTooBigException {
        return this.destroyShift(tree, player, player.method_6047());
    }

    private boolean destroyShift(Tree tree, class_1657 player, class_1799 tool) throws BreakTreeTooBigException {
        Optional<TreePart> treePartOptional = tree.getLastSequencePart();
        if (treePartOptional.isPresent()) {
            TreePart treePart = treePartOptional.get();
            class_1937 level = tree.getLevel();
            if (treePart.treePartType() == TreePartType.NETHER_WART && FallingTree.config.getTrees().isInstantlyBreakWarts()) {
                return this.breakElements(tree, level, player, tool, tree.getWarts());
            }
            return this.breakElements(tree, level, player, tool, List.of(treePart));
        }
        return false;
    }

    private boolean breakElements(Tree tree, class_1937 level, class_1657 player, class_1799 tool, Collection<TreePart> parts) throws BreakTreeTooBigException {
        int count = parts.size();
        ToolDamageHandler toolHandler = new ToolDamageHandler(tool, FallingTree.config.getTools().getDamageMultiplicand(), FallingTree.config.getTools().isPreserve(), count);
        if (toolHandler.getMaxBreakCount() <= 0) {
            FallingTree.logger.debug("Didn't break tree at {} as {}'s tool was about to break", (Object)tree.getHitPos(), (Object)player);
            FallingTreeUtils.notifyPlayer(player, (class_2561)new class_2588("chat.fallingtree.prevented_break_tool"));
            return false;
        }
        int breakCount = parts.stream().mapToInt(wart -> this.breakPart(tree, (TreePart)wart, level, player, tool)).sum();
        int damage = toolHandler.getActualDamage(breakCount);
        if (damage > 0) {
            tool.method_7956(damage, (class_1309)player, entity -> {});
        }
        return true;
    }

    private int breakPart(Tree tree, TreePart treePart, class_1937 level, class_1657 player, class_1799 tool) {
        class_2338 blockPos = treePart.blockPos();
        class_2680 logState = level.method_8320(blockPos);
        logState.method_26204().method_9556(level, player, tree.getHitPos(), logState, level.method_8321(blockPos), tool);
        level.method_8650(blockPos, false);
        return 1;
    }

    public static ShiftDownTreeBreakingHandler getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ShiftDownTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

