/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.fabric.tree.breaking;

import fr.raksrinana.fallingtree.fabric.FallingTree;
import fr.raksrinana.fallingtree.fabric.config.DamageRounding;
import fr.raksrinana.fallingtree.fabric.config.MaxSizeAction;
import fr.raksrinana.fallingtree.fabric.tree.breaking.BreakTreeTooBigException;
import net.minecraft.class_1799;

public class ToolDamageHandler {
    private final class_1799 tool;
    private final double damageMultiplicand;
    private final int maxDurabilityTaken;
    private final int maxBreakCount;

    public ToolDamageHandler(class_1799 tool, double damageMultiplicand, boolean preserve, int breakableCount) throws BreakTreeTooBigException {
        int tempMaxBreakCount;
        this.tool = tool;
        this.damageMultiplicand = damageMultiplicand;
        int maxSize = FallingTree.config.getTrees().getMaxSize();
        if (breakableCount > maxSize && FallingTree.config.getTrees().getMaxSizeAction() == MaxSizeAction.ABORT) {
            FallingTree.logger.debug("Tree reached max size of {}", (Object)maxSize);
            throw new BreakTreeTooBigException();
        }
        if (tool.method_7963()) {
            int breakCount;
            int n = breakCount = damageMultiplicand == 0.0 ? maxSize : (int)Math.floor((double)this.getToolDurability() / damageMultiplicand);
            if (preserve && breakCount <= breakableCount) {
                --breakCount;
            }
            tempMaxBreakCount = breakCount;
        } else {
            tempMaxBreakCount = maxSize;
        }
        this.maxBreakCount = Math.min(maxSize, tempMaxBreakCount);
        this.maxDurabilityTaken = this.getDamage(this.maxBreakCount);
    }

    private int getDamage(long count) {
        if (Double.compare(this.damageMultiplicand, 0.0) <= 0) {
            return 1;
        }
        double rawDamage = (double)count * this.damageMultiplicand;
        return switch (FallingTree.config.getTools().getDamageRounding()) {
            case DamageRounding.ROUND_DOWN -> (int)Math.floor(rawDamage);
            case DamageRounding.ROUND_UP -> (int)Math.ceil(rawDamage);
            case DamageRounding.ROUNDING -> (int)Math.round(rawDamage);
            case DamageRounding.PROBABILISTIC -> this.getProbabilisticDamage(rawDamage);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private int getProbabilisticDamage(double rawDamage) {
        double damage = Math.floor(rawDamage);
        int finalDamage = (int)damage;
        double probability = rawDamage - damage;
        if (Math.random() < probability) {
            ++finalDamage;
        }
        return finalDamage;
    }

    public int getActualDamage(int brokenCount) {
        if (this.tool.method_7963()) {
            return brokenCount == this.maxBreakCount ? this.maxDurabilityTaken : Math.min(this.maxDurabilityTaken, this.getDamage(brokenCount));
        }
        return 0;
    }

    private int getToolDurability() {
        if (this.tool.method_7963()) {
            return this.tool.method_7936() - this.tool.method_7919();
        }
        return Integer.MAX_VALUE;
    }

    public int getMaxBreakCount() {
        return this.maxBreakCount;
    }
}

