/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.config;

import fr.raksrinana.fallingtree.forge.config.NotificationMode;
import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.config.TreeConfiguration;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static final String[] DESC_REVERSE_SNEAKING = new String[]{"When set to true, a tree will, only be chopped down if the player is sneaking."};
    private static final String[] DESC_BREAK_IN_CREATIVE = new String[]{"When set to true, the mod will, cut down trees in creative too."};
    private static final String[] DESC_NOTIFICATION_MODE = new String[]{"How messages are sent to the player.", "CHAT: Messages are sent in the chat.", "ACTION_BAR: Messages are displayed in the player's action bar.", "NONE: No notifications will appear."};
    private final TreeConfiguration trees;
    private final ToolConfiguration tools;
    private final ForgeConfigSpec.BooleanValue reverseSneaking;
    private final ForgeConfigSpec.BooleanValue breakInCreative;
    private final ForgeConfigSpec.ConfigValue<NotificationMode> notificationMode;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Falling Tree configuration");
        builder.push("trees");
        this.trees = new TreeConfiguration(builder);
        builder.pop();
        builder.push("tools");
        this.tools = new ToolConfiguration(builder);
        builder.pop();
        this.reverseSneaking = builder.comment(DESC_REVERSE_SNEAKING).define("reverse_sneaking", false);
        this.breakInCreative = builder.comment(DESC_BREAK_IN_CREATIVE).define("break_in_creative", false);
        this.notificationMode = builder.comment(DESC_NOTIFICATION_MODE).defineEnum("notification_mode", (Enum)NotificationMode.ACTION_BAR);
    }

    public void setBreakInCreative(Boolean value) {
        this.breakInCreative.set((Object)value);
    }

    public void setReverseSneaking(Boolean value) {
        this.reverseSneaking.set((Object)value);
    }

    public void setNotificationMode(NotificationMode value) {
        this.notificationMode.set((Object)value);
    }

    public boolean isReverseSneaking() {
        return (Boolean)this.reverseSneaking.get();
    }

    public boolean isBreakInCreative() {
        return (Boolean)this.breakInCreative.get();
    }

    public NotificationMode getNotificationMode() {
        return (NotificationMode)((Object)this.notificationMode.get());
    }

    public TreeConfiguration getTrees() {
        return this.trees;
    }

    public ToolConfiguration getTools() {
        return this.tools;
    }

    public ForgeConfigSpec.BooleanValue getReverseSneaking() {
        return this.reverseSneaking;
    }

    public ForgeConfigSpec.BooleanValue getBreakInCreative() {
        return this.breakInCreative;
    }
}

