/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.tree.builder;

import fr.raksrinana.fallingtree.forge.FallingTree;
import fr.raksrinana.fallingtree.forge.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.ConfigCache;
import fr.raksrinana.fallingtree.forge.config.DetectionMode;
import fr.raksrinana.fallingtree.forge.tree.Tree;
import fr.raksrinana.fallingtree.forge.tree.builder.AbortSearchException;
import fr.raksrinana.fallingtree.forge.tree.builder.AdjacentAbortSearchException;
import fr.raksrinana.fallingtree.forge.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.forge.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.forge.tree.builder.position.AbovePositionFetcher;
import fr.raksrinana.fallingtree.forge.tree.builder.position.AboveYFetcher;
import fr.raksrinana.fallingtree.forge.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.forge.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.forge.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class TreeBuilder {
    private static final EnumSet<Direction> ALL_DIRECTIONS = EnumSet.allOf(Direction.class);

    public static Optional<Tree> getTree(Player player, Level level, BlockPos originPos) throws TreeTooBigException {
        Block originBlock = level.m_8055_(originPos).m_60734_();
        if (!FallingTreeUtils.isLogBlock(originBlock)) {
            return Optional.empty();
        }
        int maxScanSize = Config.COMMON.getTrees().getMaxScanSize();
        PriorityQueue<ToAnalyzePos> toAnalyzePos = new PriorityQueue<ToAnalyzePos>();
        HashSet<ToAnalyzePos> analyzedPos = new HashSet<ToAnalyzePos>();
        Tree tree = new Tree(level, originPos);
        toAnalyzePos.add(new ToAnalyzePos(TreeBuilder.getFirstPositionFetcher(), originPos, originBlock, originPos, originBlock, TreePartType.LOG, 0));
        Predicate<BlockPos> boundingBoxSearch = TreeBuilder.getBoundingBoxSearch(originPos);
        Predicate<Block> adjacentPredicate = TreeBuilder.getAdjacentPredicate();
        try {
            TreeBuilder.checkAdjacent(adjacentPredicate, level, originPos);
            while (!toAnalyzePos.isEmpty()) {
                ToAnalyzePos analyzingPos = (ToAnalyzePos)toAnalyzePos.remove();
                tree.addPart(analyzingPos.toTreePart());
                analyzedPos.add(analyzingPos);
                if (tree.getSize() > maxScanSize) {
                    FallingTree.logger.debug("Tree at {} reached max scan size of {}", (Object)tree.getHitPos(), (Object)maxScanSize);
                    throw new TreeTooBigException();
                }
                Collection<ToAnalyzePos> potentialPositions = analyzingPos.positionFetcher().getPositions(level, originPos, analyzingPos);
                Collection<ToAnalyzePos> nextPositions = TreeBuilder.filterPotentialPos(boundingBoxSearch, adjacentPredicate, level, originPos, originBlock, analyzingPos, potentialPositions, analyzedPos);
                nextPositions.removeAll(analyzedPos);
                nextPositions.removeAll(toAnalyzePos);
                toAnalyzePos.addAll(nextPositions);
            }
            TreeBuilder.postProcess(tree);
        }
        catch (AbortSearchException e) {
            FallingTree.logger.debug("Didn't cut tree at {}, reason: {}", (Object)originPos, (Object)e.getMessage());
            FallingTreeUtils.notifyPlayer(player, (Component)new TranslatableComponent("chat.fallingtree.search_aborted").m_7220_(e.getComponent()));
            return Optional.empty();
        }
        if (Config.COMMON.getTrees().getBreakMode().isCheckLeavesAround()) {
            int aroundRequired = Config.COMMON.getTrees().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeBuilder.getLeavesAround(level, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                FallingTree.logger.debug("Tree at {} doesn't have enough leaves around top most log", (Object)originPos);
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static void postProcess(Tree tree) {
        tree.getTopMostLog().ifPresent(topMostLog -> tree.removePartsHigherThan(topMostLog.m_123342_() + 1, TreePartType.NETHER_WART));
    }

    private static Predicate<Block> getAdjacentPredicate() {
        Collection<Block> whitelist = Config.COMMON.getTrees().getWhitelistedAdjacentBlockBlocks();
        Collection<Block> base = ConfigCache.getInstance().getAdjacentBlocksBase();
        if (whitelist.isEmpty()) {
            return block -> true;
        }
        return switch (Config.COMMON.getTrees().getAdjacentStopMode()) {
            case AdjacentStopMode.STOP_ALL -> block -> {
                boolean whitelisted;
                boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                if (!whitelisted) {
                    throw new AdjacentAbortSearchException((Block)block);
                }
                return true;
            };
            case AdjacentStopMode.STOP_BRANCH -> block -> {
                boolean whitelisted;
                boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                if (!whitelisted) {
                    FallingTree.logger.debug("Found block {} that isn't whitelisted in the adjacent blocks, branch will be ignored further", block);
                    return false;
                }
                return true;
            };
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static Predicate<BlockPos> getBoundingBoxSearch(BlockPos originPos) {
        int radius = Config.COMMON.getTrees().getSearchAreaRadius();
        if (radius < 0) {
            return pos -> true;
        }
        int minX = originPos.m_123341_() - radius;
        int maxX = originPos.m_123341_() + radius;
        int minZ = originPos.m_123343_() - radius;
        int maxZ = originPos.m_123343_() + radius;
        return pos -> minX <= pos.m_123341_() && maxX >= pos.m_123341_() && minZ <= pos.m_123343_() && maxZ >= pos.m_123343_();
    }

    private static IPositionFetcher getFirstPositionFetcher() {
        DetectionMode detectionMode = Config.COMMON.getTrees().getDetectionMode();
        return switch (detectionMode) {
            case DetectionMode.ABOVE_CUT -> AbovePositionFetcher.getInstance();
            case DetectionMode.ABOVE_Y -> AboveYFetcher.getInstance();
            case DetectionMode.WHOLE_TREE -> BasicPositionFetcher.getInstance();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static Collection<ToAnalyzePos> filterPotentialPos(Predicate<BlockPos> boundingBoxSearch, Predicate<Block> adjacentPredicate, Level level, BlockPos originPos, Block originBlock, ToAnalyzePos parent, Collection<ToAnalyzePos> potentialPos, Collection<ToAnalyzePos> analyzedPos) {
        return potentialPos.stream().filter(pos -> !analyzedPos.contains(pos)).filter(pos -> TreeBuilder.shouldIncludeInChain(boundingBoxSearch, originPos, originBlock, parent, pos)).filter(pos -> TreeBuilder.checkAdjacent(adjacentPredicate, level, pos.checkPos())).collect(Collectors.toList());
    }

    private static boolean checkAdjacent(Predicate<Block> adjacentPredicate, Level level, BlockPos pos) {
        return EnumSet.allOf(Direction.class).stream().map(arg_0 -> ((BlockPos)pos).m_142300_(arg_0)).map(arg_0 -> ((Level)level).m_8055_(arg_0)).map(BlockBehaviour.BlockStateBase::m_60734_).allMatch(adjacentPredicate);
    }

    private static long getLeavesAround(Level level, BlockPos blockPos) {
        return ALL_DIRECTIONS.stream().map(arg_0 -> ((BlockPos)blockPos).m_142300_(arg_0)).filter(testPos -> {
            Block block = level.m_8055_(testPos).m_60734_();
            return FallingTreeUtils.isLeafBlock(block) || FallingTreeUtils.isNetherWartOrShroomlight(block) || FallingTreeUtils.isLeafNeedBreakBlock(block);
        }).count();
    }

    private static boolean shouldIncludeInChain(Predicate<BlockPos> boundingBoxSearch, BlockPos originPos, Block originBlock, ToAnalyzePos parent, ToAnalyzePos check) {
        if (parent.treePartType() == TreePartType.LOG && TreeBuilder.isSameTree(originBlock, check) && boundingBoxSearch.test(check.checkPos())) {
            return true;
        }
        if (Config.COMMON.getTrees().isBreakNetherTreeWarts() && check.treePartType() == TreePartType.NETHER_WART) {
            BlockPos checkBlockPos = check.checkPos();
            int dx = Math.abs(originPos.m_123341_() - checkBlockPos.m_123341_());
            int dz = Math.abs(originPos.m_123343_() - checkBlockPos.m_123343_());
            return dx <= 4 && dz <= 4;
        }
        return check.treePartType() == TreePartType.LEAF_NEED_BREAK;
    }

    private static boolean isSameTree(Block parentLogBlock, ToAnalyzePos check) {
        if (Config.COMMON.getTrees().isAllowMixedLogs()) {
            return check.treePartType() == TreePartType.LOG;
        }
        return check.checkBlock().equals(parentLogBlock);
    }
}

