/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.utils;

import fr.raksrinana.fallingtree.forge.config.Config;
import fr.raksrinana.fallingtree.forge.config.ConfigCache;
import fr.raksrinana.fallingtree.forge.config.ToolConfiguration;
import fr.raksrinana.fallingtree.forge.utils.TreePartType;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class FallingTreeUtils {
    public static Set<Item> getAsItems(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getItem).filter(Objects::nonNull).filter(item -> !Items.f_41852_.equals(item)).collect(Collectors.toSet());
    }

    @Nonnull
    public static Stream<Item> getItem(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(ItemTags.m_13193_().m_13404_(resourceLocation)).stream().map(Tag::m_6497_).flatMap(Collection::stream);
            }
            return Stream.of((Item)ForgeRegistries.ITEMS.getValue(resourceLocation));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static Set<Block> getAsBlocks(Collection<? extends String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(FallingTreeUtils::getBlock).filter(Objects::nonNull).filter(block -> !Blocks.f_50016_.equals(block)).collect(Collectors.toSet());
    }

    @Nonnull
    public static Stream<Block> getBlock(String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                return Optional.ofNullable(BlockTags.m_13115_().m_13404_(resourceLocation)).stream().map(Tag::m_6497_).flatMap(Collection::stream);
            }
            return Stream.of((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation));
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    public static boolean isLeafBlock(@Nonnull Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = BlockTags.f_13035_.m_8110_((Object)block) || Config.COMMON.getTrees().getWhitelistedLeaveBlocks().stream().anyMatch(leaf -> leaf.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTrees().getBlacklistedLeaveBlocks().stream().anyMatch(leaf -> leaf.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean canPlayerBreakTree(Player player, BlockState aimedBlockState) {
        boolean isWhitelistedTool;
        ToolConfiguration toolConfiguration = Config.COMMON.getTools();
        ItemStack heldItemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item heldItem = heldItemStack.m_41720_();
        boolean bl = isWhitelistedTool = toolConfiguration.isIgnoreTools() || heldItem.m_8102_(heldItemStack, aimedBlockState) > 1.0f || toolConfiguration.getWhitelistedItems().stream().anyMatch(tool -> tool.equals(heldItem));
        if (isWhitelistedTool) {
            boolean isBlacklistedTool = toolConfiguration.getBlacklistedItems().stream().anyMatch(tool -> tool.equals(heldItem));
            return !isBlacklistedTool;
        }
        return false;
    }

    public static TreePartType getTreePart(Block checkBlock) {
        if (FallingTreeUtils.isLogBlock(checkBlock)) {
            return TreePartType.LOG;
        }
        if (FallingTreeUtils.isNetherWartOrShroomlight(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (FallingTreeUtils.isLeafNeedBreakBlock(checkBlock)) {
            return TreePartType.LEAF_NEED_BREAK;
        }
        return TreePartType.OTHER;
    }

    public static boolean isLeafNeedBreakBlock(Block block) {
        return Config.COMMON.getTrees().getWhitelistedNonDecayLeaveBlocks().stream().anyMatch(log -> log.equals(block));
    }

    public static boolean isLogBlock(Block block) {
        boolean isWhitelistedBlock;
        boolean bl = isWhitelistedBlock = ConfigCache.getInstance().getDefaultLogs().stream().anyMatch(log -> log.equals(block)) || Config.COMMON.getTrees().getWhitelistedLogBlocks().stream().anyMatch(log -> log.equals(block));
        if (isWhitelistedBlock) {
            boolean isBlacklistedBlock = Config.COMMON.getTrees().getBlacklistedLogBlocks().stream().anyMatch(log -> log.equals(block));
            return !isBlacklistedBlock;
        }
        return false;
    }

    public static boolean isNetherWartOrShroomlight(Block block) {
        return BlockTags.f_13078_.m_8110_((Object)block) || block.equals(Blocks.f_50701_);
    }

    public static void notifyPlayer(Player player, Component text) {
        Player player2 = player;
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            switch (Config.COMMON.getNotificationMode()) {
                case CHAT: {
                    player.m_6352_(text, Util.f_137441_);
                    break;
                }
                case ACTION_BAR: {
                    serverPlayer.m_9146_(text, ChatType.GAME_INFO, Util.f_137441_);
                }
            }
        } else {
            player.m_6352_(text, Util.f_137441_);
        }
    }
}

