/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.event;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.tree.BreakTreeResult;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockPosWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockStateWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.LevelWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.PlayerWrapper;
import fr.raksrinana.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class BlockBreakListener {
    @NotNull
    private final FallingTreeCommon<?> mod;

    @SubscribeEvent
    public void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getPlayer());
        BlockStateWrapper wrappedState = new BlockStateWrapper(event.getState());
        BlockPosWrapper wrappedPos = new BlockPosWrapper(event.getPos());
        Optional<Float> result = this.mod.getTreeHandler().getBreakSpeed(wrappedPlayer, wrappedState, wrappedPos, event.getNewSpeed());
        if (result.isEmpty()) {
            return;
        }
        event.setNewSpeed(result.get().floatValue());
    }

    @SubscribeEvent
    public void onBlockBreakEvent(@Nonnull BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event instanceof FallingTreeBlockBreakEvent) {
            return;
        }
        PlayerWrapper wrappedPlayer = new PlayerWrapper(event.getPlayer());
        LevelWrapper wrappedLevel = new LevelWrapper(event.getWorld());
        BlockPosWrapper wrappedPos = new BlockPosWrapper(event.getPos());
        Optional<BreakTreeResult> result = this.mod.getTreeHandler().breakTree(wrappedLevel, wrappedPlayer, wrappedPos);
        if (result.isEmpty()) {
            return;
        }
        if (event.isCancelable()) {
            switch (result.get().breakMode()) {
                case INSTANTANEOUS: {
                    event.setCanceled(result.get().shouldCancel());
                    break;
                }
                case SHIFT_DOWN: {
                    event.setCanceled(true);
                }
            }
        }
    }

    public BlockBreakListener(@NotNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

