/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common.config.real;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public class ConfigLoader {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();

    @NotNull
    static <T> T loadConfig(@NotNull T config, @NotNull Class<T> clazz, @NotNull Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                config = gson.fromJson((Reader)reader, clazz);
            }
        }
        return ConfigLoader.saveConfig(config, path);
    }

    @NotNull
    static <T> T saveConfig(@NotNull T config, @NotNull Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            gson.toJson(config, (Appendable)writer);
        }
        return config;
    }
}

