/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.common.wrapper;

import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.wrapper.IComponent;
import fr.rakambda.fallingtree.common.wrapper.IItem;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import fr.rakambda.fallingtree.forge.common.wrapper.ItemStackWrapper;
import fr.rakambda.fallingtree.forge.common.wrapper.LevelWrapper;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class PlayerWrapper
implements IPlayer {
    @NotNull
    private final Player raw;

    @Override
    public void sendMessage(@NotNull IComponent component, @NotNull NotificationMode mode) {
        Component text = (Component)component.getRaw();
        Player player = this.raw;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            switch (mode) {
                case CHAT: {
                    serverPlayer.m_240418_(text, false);
                    break;
                }
                case ACTION_BAR: {
                    serverPlayer.m_240418_(text, true);
                }
            }
        } else {
            this.raw.m_213846_(text);
        }
    }

    @Override
    @NotNull
    public IItemStack getMainHandItem() {
        return new ItemStackWrapper(this.raw.m_21205_());
    }

    @Override
    public void awardItemUsed(@NotNull IItem item) {
        this.raw.m_36246_(Stats.f_12982_.m_12902_((Object)((Item)item.getRaw())));
    }

    @Override
    public boolean isCreative() {
        return this.raw.m_7500_();
    }

    @Override
    public boolean isCrouching() {
        return this.raw.m_6047_();
    }

    @Override
    @NotNull
    public UUID getUUID() {
        return this.raw.m_20148_();
    }

    @Override
    @NotNull
    public ILevel getLevel() {
        return new LevelWrapper((LevelAccessor)this.raw.m_20193_());
    }

    @Override
    @NotNull
    public Set<String> getTags() {
        return this.raw.m_19880_();
    }

    @Override
    public boolean addTag(@NotNull String tag) {
        return this.raw.m_20049_(tag);
    }

    @Override
    public boolean removeTag(@NotNull String tag) {
        return this.raw.m_20137_(tag);
    }

    public PlayerWrapper(@NotNull Player raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "PlayerWrapper(raw=" + this.getRaw() + ")";
    }

    @NotNull
    public Player getRaw() {
        return this.raw;
    }
}

