/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.proxy;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.IResettable;
import fr.rakambda.fallingtree.common.config.ITreeConfiguration;
import fr.rakambda.fallingtree.common.config.enums.AdjacentStopMode;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.config.enums.BreakOrder;
import fr.rakambda.fallingtree.common.config.enums.DetectionMode;
import fr.rakambda.fallingtree.common.config.enums.MaxSizeAction;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TreeProxyConfiguration
implements ITreeConfiguration,
IResettable {
    private final ITreeConfiguration delegate;
    private BreakMode breakMode;

    @Override
    public void reset() {
        this.breakMode = null;
    }

    @Override
    @NotNull
    public Collection<IBlock> getAllowedNonDecayLeaveBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedNonDecayLeaveBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getDeniedLeaveBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getDeniedLeaveBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getDeniedLogBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getDeniedLogBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getAllowedLeaveBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedLeaveBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getAllowedLogBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedLogBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getAllowedAdjacentBlockBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedAdjacentBlockBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getDefaultLogsBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getDefaultLogsBlocks(mod);
    }

    @Override
    @NotNull
    public Collection<IBlock> getAllAllowedAdjacentBlockBlocks(@NotNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllAllowedAdjacentBlockBlocks(mod);
    }

    @Override
    @NotNull
    public BreakMode getBreakMode() {
        return Optional.ofNullable(this.breakMode).orElseGet(this.delegate::getBreakMode);
    }

    @Override
    @NotNull
    public DetectionMode getDetectionMode() {
        return this.delegate.getDetectionMode();
    }

    @Override
    public int getMaxScanSize() {
        return this.delegate.getMaxScanSize();
    }

    @Override
    public int getMaxSize() {
        return this.delegate.getMaxSize();
    }

    @Override
    @NotNull
    public MaxSizeAction getMaxSizeAction() {
        return this.delegate.getMaxSizeAction();
    }

    @Override
    @NotNull
    public BreakOrder getBreakOrder() {
        return this.delegate.getBreakOrder();
    }

    @Override
    public int getMinimumLeavesAroundRequired() {
        return this.delegate.getMinimumLeavesAroundRequired();
    }

    @Override
    public boolean isIncludePersistentLeavesInRequiredCount() {
        return this.delegate.isIncludePersistentLeavesInRequiredCount();
    }

    @Override
    public boolean isTreeBreaking() {
        return this.delegate.isTreeBreaking();
    }

    @Override
    public boolean isLeavesBreaking() {
        return this.delegate.isLeavesBreaking();
    }

    @Override
    public int getLeavesBreakingForceRadius() {
        return this.delegate.getLeavesBreakingForceRadius();
    }

    @Override
    public boolean isAllowMixedLogs() {
        return this.delegate.isAllowMixedLogs();
    }

    @Override
    public boolean isBreakNetherTreeWarts() {
        return this.delegate.isBreakNetherTreeWarts();
    }

    @Override
    public boolean isBreakMangroveRoots() {
        return this.delegate.isBreakMangroveRoots();
    }

    @Override
    public int getSearchAreaRadius() {
        return this.delegate.getSearchAreaRadius();
    }

    @Override
    @NotNull
    public AdjacentStopMode getAdjacentStopMode() {
        return this.delegate.getAdjacentStopMode();
    }

    public TreeProxyConfiguration(ITreeConfiguration delegate) {
        this.delegate = delegate;
    }

    public void setBreakMode(BreakMode breakMode) {
        this.breakMode = breakMode;
    }
}

