/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.network;

import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.wrapper.IFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class ConfigurationPacket {
    private double speedMultiplicand;
    private boolean forceToolUsage;
    private BreakMode breakMode;

    public static ConfigurationPacket get(@NotNull IConfiguration configuration) {
        return ConfigurationPacket.builder().speedMultiplicand(configuration.getTools().getSpeedMultiplicand()).forceToolUsage(configuration.getTools().isForceToolUsage()).breakMode(configuration.getTrees().getBreakMode()).build();
    }

    public void write(IFriendlyByteBuf buf) {
        buf.writeDouble(this.getSpeedMultiplicand());
        buf.writeBoolean(this.isForceToolUsage());
        buf.writeInteger(this.getBreakMode().ordinal());
    }

    public static ConfigurationPacket read(IFriendlyByteBuf buf) {
        return ConfigurationPacket.builder().speedMultiplicand(buf.readDouble()).forceToolUsage(buf.readBoolean()).breakMode(BreakMode.getValues()[buf.readInteger()]).build();
    }

    public static ConfigurationPacketBuilder builder() {
        return new ConfigurationPacketBuilder();
    }

    public double getSpeedMultiplicand() {
        return this.speedMultiplicand;
    }

    public boolean isForceToolUsage() {
        return this.forceToolUsage;
    }

    public BreakMode getBreakMode() {
        return this.breakMode;
    }

    public void setSpeedMultiplicand(double speedMultiplicand) {
        this.speedMultiplicand = speedMultiplicand;
    }

    public void setForceToolUsage(boolean forceToolUsage) {
        this.forceToolUsage = forceToolUsage;
    }

    public void setBreakMode(BreakMode breakMode) {
        this.breakMode = breakMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationPacket)) {
            return false;
        }
        ConfigurationPacket other = (ConfigurationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getSpeedMultiplicand(), other.getSpeedMultiplicand()) != 0) {
            return false;
        }
        if (this.isForceToolUsage() != other.isForceToolUsage()) {
            return false;
        }
        BreakMode this$breakMode = this.getBreakMode();
        BreakMode other$breakMode = other.getBreakMode();
        return !(this$breakMode == null ? other$breakMode != null : !((Object)((Object)this$breakMode)).equals((Object)other$breakMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigurationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $speedMultiplicand = Double.doubleToLongBits(this.getSpeedMultiplicand());
        result = result * 59 + (int)($speedMultiplicand >>> 32 ^ $speedMultiplicand);
        result = result * 59 + (this.isForceToolUsage() ? 79 : 97);
        BreakMode $breakMode = this.getBreakMode();
        result = result * 59 + ($breakMode == null ? 43 : ((Object)((Object)$breakMode)).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigurationPacket(speedMultiplicand=" + this.getSpeedMultiplicand() + ", forceToolUsage=" + this.isForceToolUsage() + ", breakMode=" + this.getBreakMode() + ")";
    }

    public ConfigurationPacket() {
    }

    public ConfigurationPacket(double speedMultiplicand, boolean forceToolUsage, BreakMode breakMode) {
        this.speedMultiplicand = speedMultiplicand;
        this.forceToolUsage = forceToolUsage;
        this.breakMode = breakMode;
    }

    public static class ConfigurationPacketBuilder {
        private double speedMultiplicand;
        private boolean forceToolUsage;
        private BreakMode breakMode;

        ConfigurationPacketBuilder() {
        }

        public ConfigurationPacketBuilder speedMultiplicand(double speedMultiplicand) {
            this.speedMultiplicand = speedMultiplicand;
            return this;
        }

        public ConfigurationPacketBuilder forceToolUsage(boolean forceToolUsage) {
            this.forceToolUsage = forceToolUsage;
            return this;
        }

        public ConfigurationPacketBuilder breakMode(BreakMode breakMode) {
            this.breakMode = breakMode;
            return this;
        }

        public ConfigurationPacket build() {
            return new ConfigurationPacket(this.speedMultiplicand, this.forceToolUsage, this.breakMode);
        }

        public String toString() {
            return "ConfigurationPacket.ConfigurationPacketBuilder(speedMultiplicand=" + this.speedMultiplicand + ", forceToolUsage=" + this.forceToolUsage + ", breakMode=" + this.breakMode + ")";
        }
    }
}

