/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import fr.raksrinana.fallingtree.config.ConfigCache;
import fr.raksrinana.fallingtree.config.ToolConfiguration;
import fr.raksrinana.fallingtree.config.TreeConfiguration;
import fr.raksrinana.fallingtree.config.validator.BlockIdRunner;
import fr.raksrinana.fallingtree.config.validator.ItemIdRunner;
import fr.raksrinana.fallingtree.config.validator.MaxRunner;
import fr.raksrinana.fallingtree.config.validator.MinMaxRunner;
import fr.raksrinana.fallingtree.config.validator.MinRunner;
import fr.raksrinana.fallingtree.config.validator.ValidatorRunner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.ConfigHolder;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.GuiRegistry;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import me.sargunvohra.mcmods.autoconfig1u.shadowed.blue.endless.jankson.Comment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;

@Config(name="fallingtree")
public class Configuration
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static final MinRunner MIN_RUNNER = new MinRunner();
    @ConfigEntry.Gui.Excluded
    private static final MaxRunner MAX_RUNNER = new MaxRunner();
    @ConfigEntry.Gui.Excluded
    private static final MinMaxRunner MIN_MAX_RUNNER = new MinMaxRunner();
    @ConfigEntry.Gui.Excluded
    private static final BlockIdRunner BLOCK_ID_RUNNER = new BlockIdRunner();
    @ConfigEntry.Gui.Excluded
    private static final ItemIdRunner ITEM_ID_RUNNER = new ItemIdRunner();
    @ConfigEntry.Gui.Excluded
    private static final List<ValidatorRunner<?>> RUNNERS = Arrays.asList(MIN_RUNNER, MAX_RUNNER, MIN_MAX_RUNNER, BLOCK_ID_RUNNER, ITEM_ID_RUNNER);
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, a tree will only be chopped down if the player is sneaking.")
    public boolean reverseSneaking = false;
    @ConfigEntry.Gui.Tooltip(count=2)
    @Comment(value="When set to true, the mod will cut down trees in creative too.")
    public boolean breakInCreative = false;
    @ConfigEntry.Category(value="trees")
    @ConfigEntry.Gui.TransitiveObject
    public TreeConfiguration trees = new TreeConfiguration();
    @ConfigEntry.Category(value="tools")
    @ConfigEntry.Gui.TransitiveObject
    public ToolConfiguration tools = new ToolConfiguration();

    public static Configuration register() {
        ConfigHolder configHolder = AutoConfig.register(Configuration.class, JanksonConfigSerializer::new);
        configHolder.registerSaveListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        configHolder.registerLoadListener((configHolder1, configuration) -> {
            ConfigCache.getInstance().invalidate();
            return class_1269.field_5811;
        });
        Configuration configuration2 = (Configuration)configHolder.getConfig();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Configuration.registerGui();
        }
        return configuration2;
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerGui() {
        GuiRegistry registry = AutoConfig.getGuiRegistry(Configuration.class);
        RUNNERS.forEach(runner -> registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> gui.setErrorSupplier(() -> runner.apply(gui.getValue(), field))).collect(Collectors.toList()), new Class[]{runner.getAnnotationClass()}));
    }

    public void validatePostLoad() throws ConfigData.ValidationException {
        Configuration.runValidators(Configuration.class, this, "general");
        Configuration.runValidators(ToolConfiguration.class, this.tools, "tools");
        Configuration.runValidators(TreeConfiguration.class, this.trees, "trees");
    }

    private static <T> void runValidators(Class<T> categoryClass, T category, String categoryName) throws ConfigData.ValidationException {
        try {
            for (Field field : categoryClass.getDeclaredFields()) {
                for (ValidatorRunner<?> validator : RUNNERS) {
                    if (validator.validateIfAnnotated(field, category)) continue;
                    throw new ConfigData.ValidationException("FallingTree config field " + categoryName + "." + field.getName() + " is invalid");
                }
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new ConfigData.ValidationException((Throwable)e);
        }
    }

    public ToolConfiguration getToolsConfiguration() {
        return this.tools;
    }

    public TreeConfiguration getTreesConfiguration() {
        return this.trees;
    }

    public boolean isBreakInCreative() {
        return this.breakInCreative;
    }

    public boolean isReverseSneaking() {
        return this.reverseSneaking;
    }
}

