/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config.validator;

import fr.raksrinana.fallingtree.config.validator.BlockId;
import fr.raksrinana.fallingtree.config.validator.ValidatorRunner;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class BlockIdRunner
implements ValidatorRunner<BlockId> {
    private static final Pattern MINECRAFT_ID_PATTERN = Pattern.compile("#?[a-z0-9_.-]+:[a-z0-9/._-]+");
    private static final class_2561 errorText = new class_2588("text.autoconfig.fallingtree.error.invalidBlockResourceLocation");

    @Override
    public Optional<class_2561> apply(Object value, BlockId annotation) {
        List list;
        boolean valid;
        if (value == null) {
            return Optional.of(errorText);
        }
        if (value instanceof String) {
            boolean valid2;
            String val2 = value.toString();
            if (!(annotation.allowEmpty() && val2.isEmpty() || (valid2 = MINECRAFT_ID_PATTERN.matcher((String)value).matches()))) {
                return Optional.of(errorText);
            }
        } else if (value instanceof List && !(valid = (list = (List)value).stream().filter(Objects::nonNull).map(Object::toString).allMatch(val -> MINECRAFT_ID_PATTERN.matcher((CharSequence)val).matches()))) {
            return Optional.of(errorText);
        }
        return Optional.empty();
    }

    @Override
    public Class<BlockId> getAnnotationClass() {
        return BlockId.class;
    }
}

