/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.mixin;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.leaves.LeafBreakingHandler;
import fr.raksrinana.fallingtree.leaves.LeafBreakingSchedule;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import java.util.EnumSet;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1937.class})
public abstract class WorldMixin {
    @Inject(method={"updateNeighborsAlways"}, at={@At(value="TAIL")})
    public void updateNeighborsAlways(class_2338 pos, class_2248 block, CallbackInfo callbackInfo) {
        class_1937 world = (class_1937)this;
        if (world instanceof class_3218) {
            WorldMixin.onUpdate((class_3218)world, pos, world.method_8320(pos), EnumSet.allOf(class_2350.class));
        }
    }

    private static void onUpdate(class_3218 world, class_2338 eventPos, class_2680 eventState, EnumSet<class_2350> notifiedSides) {
        class_2248 eventBlock;
        if (FallingTree.config.getTreesConfiguration().isLeavesBreaking() && (eventBlock = eventState.method_26204()).method_27839(class_2246.field_10124)) {
            for (class_2350 facing : notifiedSides) {
                class_2680 neighborState;
                class_2338 neighborPos = eventPos.method_10093(facing);
                class_2791 chunk = world.method_22350(neighborPos);
                class_1923 chunkPos = chunk.method_12004();
                if (!world.method_8393(chunkPos.field_9181, chunkPos.field_9180) || !FallingTreeUtils.isLeafBlock((neighborState = world.method_8320(neighborPos)).method_26204())) continue;
                LeafBreakingHandler.scheduledLeavesBreaking.add(new LeafBreakingSchedule(world, neighborPos, 4));
            }
        }
    }

    @Inject(method={"updateNeighborsExcept"}, at={@At(value="TAIL")})
    public void updateNeighborsExcept(class_2338 pos, class_2248 sourceBlock, class_2350 direction, CallbackInfo callbackInfo) {
        class_1937 world = (class_1937)this;
        if (world instanceof class_3218) {
            EnumSet<class_2350> directions = EnumSet.allOf(class_2350.class);
            directions.remove(direction);
            WorldMixin.onUpdate((class_3218)world, pos, world.method_8320(pos), directions);
        }
    }
}

