/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree.breaking;

import fr.raksrinana.fallingtree.FallingTree;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.tree.TreePart;
import fr.raksrinana.fallingtree.tree.breaking.ITreeBreakingHandler;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import java.util.Comparator;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;

public class InstantaneousTreeBreakingHandler
implements ITreeBreakingHandler {
    private static InstantaneousTreeBreakingHandler INSTANCE;

    @Override
    public boolean breakTree(class_1657 player, Tree tree) {
        return this.destroyInstant(tree, player, player.method_6047());
    }

    private boolean destroyInstant(Tree tree, class_1657 player, class_1799 tool) {
        int brokenCount;
        int toolDamage;
        double rawWeightedUsesLeft;
        class_1937 world = tree.getWorld();
        int breakableCount = tree.getBreakableCount();
        int damageMultiplicand = FallingTree.config.getToolsConfiguration().getDamageMultiplicand();
        int toolUsesLeft = tool.method_7963() ? tool.method_7936() - tool.method_7919() : Integer.MAX_VALUE;
        double d = rawWeightedUsesLeft = damageMultiplicand == 0 ? (double)(toolUsesLeft - 1) : 1.0 * (double)toolUsesLeft / (double)damageMultiplicand;
        if (FallingTree.config.getToolsConfiguration().isPreserve()) {
            if (rawWeightedUsesLeft <= 1.0) {
                player.method_9203((class_2561)new class_2588("chat.fallingtree.prevented_break_tool"), class_156.field_25140);
                return false;
            }
            if ((double)breakableCount >= rawWeightedUsesLeft) {
                rawWeightedUsesLeft = Math.ceil(rawWeightedUsesLeft) - 1.0;
            }
        }
        if ((toolDamage = damageMultiplicand * (brokenCount = tree.getBreakableParts().stream().sorted(Comparator.comparingInt(TreePart::getSequence).reversed()).limit((int)rawWeightedUsesLeft).map(TreePart::getBlockPos).mapToInt(logBlockPos -> {
            class_2680 logState = world.method_8320(logBlockPos);
            logState.method_26204().method_9556(world, player, logBlockPos, logState, world.method_8321(logBlockPos), tool);
            world.method_8650(logBlockPos, false);
            return 1;
        }).sum()) - 1) > 0) {
            tool.method_7956(toolDamage, (class_1309)player, entity -> {});
        }
        if (brokenCount >= breakableCount) {
            this.forceBreakDecayLeaves(tree, world);
        }
        return true;
    }

    private void forceBreakDecayLeaves(Tree tree, class_1937 world) {
        int radius = FallingTree.config.getTreesConfiguration().getLeavesBreakingForceRadius();
        if (radius > 0) {
            tree.getTopMostLog().ifPresent(topLog -> {
                class_2338.class_2339 checkPos = new class_2338.class_2339();
                for (int dx = -radius; dx < radius; ++dx) {
                    for (int dy = -radius; dy < radius; ++dy) {
                        for (int dz = -radius; dz < radius; ++dz) {
                            checkPos.method_10103(topLog.method_10263() + dx, topLog.method_10264() + dy, topLog.method_10260() + dz);
                            class_2680 checkState = world.method_8320((class_2338)checkPos);
                            class_2248 checkBlock = checkState.method_26204();
                            if (!FallingTreeUtils.isLeafBlock(checkBlock)) continue;
                            class_2248.method_9497((class_2680)checkState, (class_1937)world, (class_2338)checkPos);
                            world.method_8650((class_2338)checkPos, false);
                        }
                    }
                }
            });
        }
    }

    public static InstantaneousTreeBreakingHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstantaneousTreeBreakingHandler();
        }
        return INSTANCE;
    }
}

