/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;

public class ConfigCache {
    private static ConfigCache INSTANCE;
    private Set<Item> toolsBlacklist;
    private Set<Item> toolsWhitelist;
    private Set<Block> leavesBlacklist;
    private Set<Block> logsBlacklist;
    private Set<Block> leavesWhitelist;
    private Set<Block> leavesNonDecayWhitelist;
    private Set<Block> logsWhitelist;
    private Set<Block> adjacentBlocksWhitelist;
    private Set<Block> adjacentBlocksBase;

    public void invalidate() {
        this.toolsBlacklist = null;
        this.toolsWhitelist = null;
        this.leavesBlacklist = null;
        this.leavesWhitelist = null;
        this.leavesNonDecayWhitelist = null;
        this.logsBlacklist = null;
        this.logsWhitelist = null;
        this.adjacentBlocksWhitelist = null;
        this.adjacentBlocksBase = null;
    }

    public Collection<Item> getToolsWhitelisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsWhitelist)) {
            this.toolsWhitelist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsWhitelist;
    }

    public Collection<Item> getToolsBlacklisted(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.toolsBlacklist)) {
            this.toolsBlacklist = FallingTreeUtils.getAsItems(collectionSupplier.get());
        }
        return this.toolsBlacklist;
    }

    public Collection<Block> getBlacklistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesBlacklist)) {
            this.leavesBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesBlacklist;
    }

    public Collection<Block> getBlacklistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsBlacklist)) {
            this.logsBlacklist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsBlacklist;
    }

    public Collection<Block> getWhitelistedLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesWhitelist)) {
            this.leavesWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesWhitelist;
    }

    public Collection<Block> getWhitelistedAdjacentBlocks(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.adjacentBlocksWhitelist)) {
            this.adjacentBlocksWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.adjacentBlocksWhitelist;
    }

    public Collection<Block> getAdjacentBlocksBase() {
        if (Objects.isNull(this.adjacentBlocksBase)) {
            this.adjacentBlocksBase = new HashSet<Block>();
            this.adjacentBlocksBase.add(Blocks.field_150350_a);
            this.adjacentBlocksBase.addAll(BlockTags.field_206952_E.func_230236_b_());
            this.adjacentBlocksBase.addAll(BlockTags.field_200031_h.func_230236_b_());
            this.adjacentBlocksBase.addAll(this.getWhitelistedLogs(Config.COMMON.getTreesConfiguration()::getWhitelistedLogsStr));
            this.adjacentBlocksBase.addAll(this.getWhitelistedLeaves(Config.COMMON.getTreesConfiguration()::getWhitelistedLeavesStr));
            this.adjacentBlocksBase.addAll(this.getWhitelistedNonDecayLeaves(Config.COMMON.getTreesConfiguration()::getWhitelistedNonDecayLeavesStr));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLogs(Config.COMMON.getTreesConfiguration()::getBlacklistedLogsStr));
            this.adjacentBlocksBase.removeAll(this.getBlacklistedLeaves(Config.COMMON.getTreesConfiguration()::getBlacklistedLeavesStr));
        }
        return this.adjacentBlocksBase;
    }

    public Collection<Block> getWhitelistedLogs(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.logsWhitelist)) {
            this.logsWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.logsWhitelist;
    }

    public Collection<Block> getWhitelistedNonDecayLeaves(Supplier<Collection<String>> collectionSupplier) {
        if (Objects.isNull(this.leavesNonDecayWhitelist)) {
            this.leavesNonDecayWhitelist = FallingTreeUtils.getAsBlocks(collectionSupplier.get());
        }
        return this.leavesNonDecayWhitelist;
    }

    public static ConfigCache getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new ConfigCache();
        }
        return INSTANCE;
    }
}

