/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.config;

import com.google.common.collect.Lists;
import fr.raksrinana.fallingtree.config.AdjacentStopMode;
import fr.raksrinana.fallingtree.config.BreakMode;
import fr.raksrinana.fallingtree.config.ConfigCache;
import fr.raksrinana.fallingtree.config.DetectionMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;

public class TreeConfiguration {
    private static final String[] DESC_BREAK_MODE = new String[]{"How to break the tree.", "INSTANTANEOUS will break it in one go.", "SHIFT_DOWN will make the tree fall down as you cut it, so you still have to break x blocks but don't have to climb the tree for them."};
    private static final String[] DESC_DETECTION_MODE = new String[]{"What part of the tree should be cut.", "WHOLE_TREE tree will break the whole tree.", "ABOVE_CUT will break only blocks that are connected from above the cut point.", "ABOVE_Y will break only blocks that are above the y value of the cut point."};
    private static final String[] DESC_WHITELISTED_LOGS = new String[]{"Additional list of blocks considered as logs and that will be destroyed by the mod.", "INFO: Blocks marked with the log tag will already be whitelisted."};
    private static final String[] DESC_BLACKLISTED_LOGS = new String[]{"List of blocks that should not be considered as logs.", "INFO: This wins over the whitelist."};
    private static final String[] DESC_WHITELISTED_LEAVES = new String[]{"Additional list of blocks considered as leaves (decay naturally).", "INFO: Blocks marked with the leaves tag will already be whitelisted."};
    private static final String[] DESC_WHITELISTED_NON_DECAY_LEAVES = new String[]{"Additional list of blocks considered as leaves but that doesn't decay (need to be broken by tool)."};
    private static final String[] DESC_BLACKLISTED_LEAVES = new String[]{"List of blocks that should not be considered as leaves.", "INFO: This wins over the whitelist."};
    private static final String[] DESC_MAX_SIZE = new String[]{"The maximum size of a tree. If there's more logs than this value the tree won't be cut.", "INFO: Only in INSTANTANEOUS mode."};
    private static final String[] DESC_TREE_BREAKING = new String[]{"When set to true, the mod will cut trees with one cut."};
    private static final String[] DESC_LEAVES_BREAKING = new String[]{"When set to true, leaves that should naturally break will be broken instantly."};
    private static final String[] DESC_LEAVES_BREAKING_FORCE_RADIUS = new String[]{"Radius to force break leaves. If another tree is still holding the leaves they'll still be broken.", "If the leaves are persistent (placed by player) they'll also be destroyed.", "The radius is applied from one of the top most log blocks.", "INFO: break_leaves must be activated for this to take effect.", "INFO: Only in INSTANTANEOUS mode."};
    private static final String[] DESC_MINIMUM_LEAVES_AROUND_REQUIRED = new String[]{"The minimum amount of leaves that needs to be around the top most log in order for the mod to consider it a tree.", "INFO: Only in INSTANTANEOUS mode."};
    private static final String[] DESC_ALLOW_MIXED_LOGS = new String[]{"When set to true this allow to have any kind of log in a tree trunk.", "Otherwise (false) the trunk will be considered as being only one kind of log."};
    private static final String[] DESC_BREAK_NETHER_TREE_WARTS = new String[]{"When set to true nether tree warts (leaves) will be broken along with the trunk."};
    private static final String[] DESC_SEARCH_AROUND_RADIUS = new String[]{"This defines the area in which the tree is searched. If any branch is going out of this area it won't be cut.", "This value is the radius of the area.", "i.e. Setting a value of 2 will result on an area of 3x3 centered on the log broken.", "If this value is set to a negative number then no area restriction will be applied."};
    private static final String[] DESC_WHITELISTED_ADJACENT_BLOCKS = new String[]{"List the blocks that can be against the tree. If something else is adjacent then the tree won't be cut.", "INFO: Use adjacentStopMode to define how we stop the search for the tree."};
    private static final String[] DESC_ADJACENT_STOP_MODE = new String[]{"What to do when an non whitelisted adjacent block is found.", "STOP_ALL will stop the search and nothing will be cut.", "STOP_BRANCH will stop the current branch only. The rest of the tree will be cut."};
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistedLogs;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedLogs;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistedLeaves;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistedNonDecayLeaves;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedLeaves;
    private final ForgeConfigSpec.ConfigValue<BreakMode> breakMode;
    private final ForgeConfigSpec.ConfigValue<DetectionMode> detectionMode;
    private final ForgeConfigSpec.IntValue maxSize;
    private final ForgeConfigSpec.IntValue minimumLeavesAroundRequired;
    private final ForgeConfigSpec.BooleanValue treeBreaking;
    private final ForgeConfigSpec.BooleanValue leavesBreaking;
    private final ForgeConfigSpec.IntValue leavesBreakingForceRadius;
    private final ForgeConfigSpec.BooleanValue allowMixedLogs;
    private final ForgeConfigSpec.BooleanValue breakNetherTreeWarts;
    private final ForgeConfigSpec.IntValue searchAreaRadius;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> whitelistedAdjacentBlocks;
    private final ForgeConfigSpec.ConfigValue<AdjacentStopMode> adjacentStopMode;

    public TreeConfiguration(ForgeConfigSpec.Builder builder) {
        this.breakMode = builder.comment(DESC_BREAK_MODE).defineEnum("break_mode", (Enum)BreakMode.INSTANTANEOUS);
        this.detectionMode = builder.comment(DESC_DETECTION_MODE).defineEnum("detection_mode", (Enum)DetectionMode.WHOLE_TREE);
        this.whitelistedLogs = builder.comment(DESC_WHITELISTED_LOGS).defineList("logs_whitelisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.blacklistedLogs = builder.comment(DESC_BLACKLISTED_LOGS).defineList("logs_blacklisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.whitelistedLeaves = builder.comment(DESC_WHITELISTED_LEAVES).defineList("leaves_whitelisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.whitelistedNonDecayLeaves = builder.comment(DESC_WHITELISTED_NON_DECAY_LEAVES).defineList("leaves_non_decay_whitelisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.blacklistedLeaves = builder.comment(DESC_BLACKLISTED_LEAVES).defineList("leaves_blacklisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.maxSize = builder.comment(DESC_MAX_SIZE).defineInRange("logs_max_count", 100, 1, Integer.MAX_VALUE);
        this.treeBreaking = builder.comment(DESC_TREE_BREAKING).define("tree_breaking", true);
        this.leavesBreaking = builder.comment(DESC_LEAVES_BREAKING).define("leaves_breaking", true);
        this.leavesBreakingForceRadius = builder.comment(DESC_LEAVES_BREAKING_FORCE_RADIUS).defineInRange("leaves_breaking_force_radius", 0, 0, 10);
        this.minimumLeavesAroundRequired = builder.comment(DESC_MINIMUM_LEAVES_AROUND_REQUIRED).defineInRange("minimum_leaves_around_required", 1, 0, 5);
        this.allowMixedLogs = builder.comment(DESC_ALLOW_MIXED_LOGS).define("allow_mixed_logs", false);
        this.breakNetherTreeWarts = builder.comment(DESC_BREAK_NETHER_TREE_WARTS).define("break_nether_tree_warts", true);
        this.searchAreaRadius = builder.comment(DESC_SEARCH_AROUND_RADIUS).defineInRange("search_around_radius", -1, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.whitelistedAdjacentBlocks = builder.comment(DESC_WHITELISTED_ADJACENT_BLOCKS).defineList("adjacent_blocks_whitelisted", (List)Lists.newArrayList(), Objects::nonNull);
        this.adjacentStopMode = builder.comment(DESC_ADJACENT_STOP_MODE).defineEnum("adjacent_stop_mode", (Enum)AdjacentStopMode.STOP_ALL);
    }

    public AdjacentStopMode getAdjacentStopMode() {
        return (AdjacentStopMode)((Object)this.adjacentStopMode.get());
    }

    public void setAdjacentStopMode(AdjacentStopMode value) {
        this.adjacentStopMode.set((Object)value);
    }

    public int getSearchAreaRadius() {
        return (Integer)this.searchAreaRadius.get();
    }

    public List<String> getBlacklistedLeavesStr() {
        return (List)this.blacklistedLeaves.get();
    }

    public List<String> getBlacklistedLogsStr() {
        return (List)this.blacklistedLogs.get();
    }

    public List<String> getWhitelistedLeavesStr() {
        return (List)this.whitelistedLeaves.get();
    }

    public Collection<Block> getWhitelistedNonDecayLeaves() {
        return ConfigCache.getInstance().getWhitelistedNonDecayLeaves(this::getWhitelistedNonDecayLeavesStr);
    }

    public List<String> getWhitelistedLogsStr() {
        return (List)this.whitelistedLogs.get();
    }

    public void setAllowMixedLogs(Boolean value) {
        this.allowMixedLogs.set((Object)value);
    }

    public void setBlacklistedLeaves(List<String> value) {
        this.blacklistedLeaves.set(value);
    }

    public void setBlacklistedLogs(List<String> value) {
        this.blacklistedLogs.set(value);
    }

    public void setBreakMode(BreakMode value) {
        this.breakMode.set((Object)value);
    }

    public void setBreakNetherTreeWarts(Boolean value) {
        this.breakNetherTreeWarts.set((Object)value);
    }

    public void setDetectionMode(DetectionMode value) {
        this.detectionMode.set((Object)value);
    }

    public void setLeavesBreaking(Boolean value) {
        this.leavesBreaking.set((Object)value);
    }

    public void setLeavesBreakingForceRadius(Integer value) {
        this.leavesBreakingForceRadius.set((Object)value);
    }

    public void setMaxSize(Integer value) {
        this.maxSize.set((Object)value);
    }

    public void setMinimumLeavesAroundRequired(Integer value) {
        this.minimumLeavesAroundRequired.set((Object)value);
    }

    public void setTreeBreaking(Boolean value) {
        this.treeBreaking.set((Object)value);
    }

    public void setWhitelistedLeaves(List<String> value) {
        this.whitelistedLeaves.set(value);
    }

    public List<String> getWhitelistedNonDecayLeavesStr() {
        return (List)this.whitelistedNonDecayLeaves.get();
    }

    public void setWhitelistedLogs(List<String> value) {
        this.whitelistedLogs.set(value);
    }

    public Collection<Block> getBlacklistedLeaves() {
        return ConfigCache.getInstance().getBlacklistedLeaves(this::getBlacklistedLeavesStr);
    }

    public Collection<Block> getBlacklistedLogs() {
        return ConfigCache.getInstance().getBlacklistedLogs(this::getBlacklistedLogsStr);
    }

    public boolean isLeavesBreaking() {
        return (Boolean)this.leavesBreaking.get();
    }

    public boolean isTreeBreaking() {
        return (Boolean)this.treeBreaking.get();
    }

    public int getMaxSize() {
        return (Integer)this.maxSize.get();
    }

    public int getMinimumLeavesAroundRequired() {
        return (Integer)this.minimumLeavesAroundRequired.get();
    }

    public Collection<Block> getWhitelistedLeaves() {
        return ConfigCache.getInstance().getWhitelistedLeaves(this::getWhitelistedLeavesStr);
    }

    public void setWhitelistedNonDecayLeaves(List<String> value) {
        this.whitelistedNonDecayLeaves.set(value);
    }

    public Collection<Block> getWhitelistedLogs() {
        return ConfigCache.getInstance().getWhitelistedLogs(this::getWhitelistedLogsStr);
    }

    public int getLeavesBreakingForceRadius() {
        return (Integer)this.leavesBreakingForceRadius.get();
    }

    public BreakMode getBreakMode() {
        return (BreakMode)((Object)this.breakMode.get());
    }

    public DetectionMode getDetectionMode() {
        return (DetectionMode)((Object)this.detectionMode.get());
    }

    public boolean isAllowMixedLogs() {
        return (Boolean)this.allowMixedLogs.get();
    }

    public boolean isBreakNetherTreeWarts() {
        return (Boolean)this.breakNetherTreeWarts.get();
    }

    public void setSearchAreaRadius(Integer value) {
        this.searchAreaRadius.set((Object)value);
    }

    public Collection<Block> getWhitelistedAdjacentBlocks() {
        return ConfigCache.getInstance().getWhitelistedAdjacentBlocks(this::getWhitelistedAdjacentBlocksStr);
    }

    public void setWhitelistedAdjacentBlocks(List<String> value) {
        this.whitelistedAdjacentBlocks.set(value);
    }

    public List<String> getWhitelistedAdjacentBlocksStr() {
        return (List)this.whitelistedAdjacentBlocks.get();
    }
}

