/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree.builder;

import fr.raksrinana.fallingtree.tree.TreePart;
import fr.raksrinana.fallingtree.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.utils.TreePartType;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;

public class ToAnalyzePos
implements Comparable<ToAnalyzePos> {
    private final IPositionFetcher positionFetcher;
    private final BlockPos parentPos;
    private final Block parentBlock;
    private final BlockPos checkPos;
    private final Block checkBlock;
    private final TreePartType treePartType;
    private final int sequence;

    public ToAnalyzePos(IPositionFetcher positionFetcher, BlockPos parentPos, Block parentBlock, BlockPos checkPos, Block checkBlock, TreePartType treePartType, int sequence) {
        this.positionFetcher = positionFetcher;
        this.parentPos = parentPos;
        this.parentBlock = parentBlock;
        this.checkPos = checkPos;
        this.checkBlock = checkBlock;
        this.treePartType = treePartType;
        this.sequence = sequence;
    }

    @Override
    public int compareTo(ToAnalyzePos o) {
        return 0;
    }

    public TreePart toTreePart() {
        return new TreePart(this.getCheckPos(), this.getTreePartType(), this.sequence);
    }

    public Block getCheckBlock() {
        return this.checkBlock;
    }

    public BlockPos getParentPos() {
        return this.parentPos;
    }

    public Block getParentBlock() {
        return this.parentBlock;
    }

    public BlockPos getCheckPos() {
        return this.checkPos;
    }

    public IPositionFetcher getPositionFetcher() {
        return this.positionFetcher;
    }

    public TreePartType getTreePartType() {
        return this.treePartType;
    }

    public int getSequence() {
        return this.sequence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ToAnalyzePos)) {
            return false;
        }
        ToAnalyzePos that = (ToAnalyzePos)o;
        return Objects.equals(this.getCheckPos(), that.getCheckPos());
    }

    public int hashCode() {
        return Objects.hash(this.getCheckPos());
    }
}

