/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.tree.builder;

import fr.raksrinana.fallingtree.config.Config;
import fr.raksrinana.fallingtree.config.ConfigCache;
import fr.raksrinana.fallingtree.config.DetectionMode;
import fr.raksrinana.fallingtree.tree.Tree;
import fr.raksrinana.fallingtree.tree.builder.AbortSearchException;
import fr.raksrinana.fallingtree.tree.builder.ToAnalyzePos;
import fr.raksrinana.fallingtree.tree.builder.TreeTooBigException;
import fr.raksrinana.fallingtree.tree.builder.position.AbovePositionFetcher;
import fr.raksrinana.fallingtree.tree.builder.position.AboveYFetcher;
import fr.raksrinana.fallingtree.tree.builder.position.BasicPositionFetcher;
import fr.raksrinana.fallingtree.tree.builder.position.IPositionFetcher;
import fr.raksrinana.fallingtree.utils.FallingTreeUtils;
import fr.raksrinana.fallingtree.utils.TreePartType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeBuilder {
    private static final EnumSet<Direction> ALL_DIRECTIONS = EnumSet.allOf(Direction.class);

    public static Optional<Tree> getTree(World world, BlockPos originPos) throws TreeTooBigException {
        Block originBlock = world.func_180495_p(originPos).func_177230_c();
        if (!FallingTreeUtils.isLogBlock(originBlock)) {
            return Optional.empty();
        }
        int maxLogCount = Config.COMMON.getTreesConfiguration().getMaxSize();
        PriorityQueue<ToAnalyzePos> toAnalyzePos = new PriorityQueue<ToAnalyzePos>();
        HashSet<ToAnalyzePos> analyzedPos = new HashSet<ToAnalyzePos>();
        Tree tree = new Tree(world, originPos);
        toAnalyzePos.add(new ToAnalyzePos(TreeBuilder.getFirstPositionFetcher(), originPos, originBlock, originPos, originBlock, TreePartType.LOG, 0));
        Predicate<BlockPos> boundingBoxSearch = TreeBuilder.getBoundingBoxSearch(originPos);
        Predicate<Block> adjacentPredicate = TreeBuilder.getAdjacentPredicate();
        try {
            while (!toAnalyzePos.isEmpty()) {
                ToAnalyzePos analyzingPos = (ToAnalyzePos)toAnalyzePos.remove();
                tree.addPart(analyzingPos.toTreePart());
                analyzedPos.add(analyzingPos);
                if (tree.getLogCount() > maxLogCount) {
                    throw new TreeTooBigException();
                }
                Collection<ToAnalyzePos> potentialPositions = analyzingPos.getPositionFetcher().getPositions(world, originPos, analyzingPos);
                Collection<ToAnalyzePos> nextPositions = TreeBuilder.filterPotentialPos(boundingBoxSearch, adjacentPredicate, world, originPos, originBlock, analyzingPos, potentialPositions, analyzedPos);
                nextPositions.removeAll(analyzedPos);
                nextPositions.removeAll(toAnalyzePos);
                toAnalyzePos.addAll(nextPositions);
            }
        }
        catch (AbortSearchException e) {
            return Optional.empty();
        }
        if (Config.COMMON.getTreesConfiguration().getBreakMode().shouldCheckLeavesAround()) {
            int aroundRequired = Config.COMMON.getTreesConfiguration().getMinimumLeavesAroundRequired();
            if (tree.getTopMostLog().map(topLog -> TreeBuilder.getLeavesAround(world, topLog) < (long)aroundRequired).orElse(true).booleanValue()) {
                return Optional.empty();
            }
        }
        return Optional.of(tree);
    }

    private static Predicate<Block> getAdjacentPredicate() {
        Collection<Block> whitelist = Config.COMMON.getTreesConfiguration().getWhitelistedAdjacentBlocks();
        Collection<Block> base = ConfigCache.getInstance().getAdjacentBlocksBase();
        if (whitelist.isEmpty()) {
            return block -> true;
        }
        switch (Config.COMMON.getTreesConfiguration().getAdjacentStopMode()) {
            case STOP_ALL: {
                return block -> {
                    boolean whitelisted;
                    boolean bl = whitelisted = whitelist.contains(block) || base.contains(block);
                    if (!whitelisted) {
                        throw new AbortSearchException("Found block " + block + " that isn't whitelisted");
                    }
                    return true;
                };
            }
            case STOP_BRANCH: {
                return block -> whitelist.contains(block) || base.contains(block);
            }
        }
        return block -> true;
    }

    private static Predicate<BlockPos> getBoundingBoxSearch(BlockPos originPos) {
        int radius = Config.COMMON.getTreesConfiguration().getSearchAreaRadius();
        if (radius < 0) {
            return pos -> true;
        }
        int minX = originPos.func_177958_n() - radius;
        int maxX = originPos.func_177958_n() + radius;
        int minZ = originPos.func_177952_p() - radius;
        int maxZ = originPos.func_177952_p() + radius;
        return pos -> minX <= pos.func_177958_n() && maxX >= pos.func_177958_n() && minZ <= pos.func_177952_p() && maxZ >= pos.func_177952_p();
    }

    private static IPositionFetcher getFirstPositionFetcher() {
        DetectionMode detectionMode = Config.COMMON.getTreesConfiguration().getDetectionMode();
        if (detectionMode == DetectionMode.ABOVE_CUT) {
            return AbovePositionFetcher.getInstance();
        }
        if (detectionMode == DetectionMode.ABOVE_Y) {
            return AboveYFetcher.getInstance();
        }
        return BasicPositionFetcher.getInstance();
    }

    private static Collection<ToAnalyzePos> filterPotentialPos(Predicate<BlockPos> boundingBoxSearch, Predicate<Block> adjacentPredicate, World world, BlockPos originPos, Block originBlock, ToAnalyzePos parent, Collection<ToAnalyzePos> potentialPos, Collection<ToAnalyzePos> analyzedPos) {
        return potentialPos.stream().filter(pos -> !analyzedPos.contains(pos)).filter(pos -> TreeBuilder.shouldIncludeInChain(boundingBoxSearch, originPos, originBlock, parent, pos)).filter(pos -> EnumSet.allOf(Direction.class).stream().map(direction -> pos.getCheckPos().func_177972_a(direction)).map(arg_0 -> ((World)world).func_180495_p(arg_0)).map(AbstractBlock.AbstractBlockState::func_177230_c).allMatch(adjacentPredicate)).collect(Collectors.toList());
    }

    private static long getLeavesAround(World world, BlockPos blockPos) {
        return ALL_DIRECTIONS.stream().map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0)).filter(testPos -> {
            Block block = world.func_180495_p(testPos).func_177230_c();
            return FallingTreeUtils.isLeafBlock(block) || FallingTreeUtils.isNetherWartOrShroomlight(block) || FallingTreeUtils.isLeafNeedBreakBlock(block);
        }).count();
    }

    private static boolean shouldIncludeInChain(Predicate<BlockPos> boundingBoxSearch, BlockPos originPos, Block originBlock, ToAnalyzePos parent, ToAnalyzePos check) {
        if (parent.getTreePartType() == TreePartType.LOG && TreeBuilder.isSameTree(originBlock, check) && boundingBoxSearch.test(check.getCheckPos())) {
            return true;
        }
        if (Config.COMMON.getTreesConfiguration().isBreakNetherTreeWarts() && check.getTreePartType() == TreePartType.NETHER_WART) {
            BlockPos checkBlockPos = check.getCheckPos();
            int dx = Math.abs(originPos.func_177958_n() - checkBlockPos.func_177958_n());
            int dz = Math.abs(originPos.func_177952_p() - checkBlockPos.func_177952_p());
            return dx <= 4 && dz <= 4;
        }
        return check.getTreePartType() == TreePartType.LEAF_NEED_BREAK;
    }

    private static boolean isSameTree(Block parentLogBlock, ToAnalyzePos check) {
        if (Config.COMMON.getTreesConfiguration().isAllowMixedLogs()) {
            return check.getTreePartType() == TreePartType.LOG;
        }
        return check.getCheckBlock().equals(parentLogBlock);
    }
}

