/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import com.silvaniastudios.roads.blocks.CurbBlock;
import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.enums.EnumMeta;
import com.silvaniastudios.roads.blocks.enums.IConnectable;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BarrierEndBlock
extends BlockBase
implements IConnectable,
IMetaBlockName {
    public static final PropertyEnum<EnumMeta> META_ID = PropertyEnum.func_177709_a((String)"meta", EnumMeta.class);

    public BarrierEndBlock(String name) {
        super(name, Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(META_ID, (Comparable)((Object)EnumMeta.id0)));
        this.func_149647_a(FurenikusRoads.tab_road_parts);
        this.func_149711_c(1.5f);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rot = 0;
        if (placer.func_174811_aO() == EnumFacing.EAST) {
            rot = 1;
        }
        if (placer.func_174811_aO() == EnumFacing.SOUTH) {
            rot = 2;
        }
        if (placer.func_174811_aO() == EnumFacing.WEST) {
            rot = 3;
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta + rot, placer);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta < 4) {
            return 0;
        }
        if (meta < 8) {
            return 4;
        }
        if (meta < 12) {
            return 8;
        }
        if (meta < 16) {
            return 12;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META_ID});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(META_ID, (Comparable)((Object)EnumMeta.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMeta)((Object)state.func_177229_b(META_ID))).getMetadata();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBox(state, world, pos);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getBox(state, world, pos);
    }

    private AxisAlignedBB getBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        double p = 0.0625;
        if (meta == 0) {
            return new AxisAlignedBB(p * 5.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, p * 11.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, p * 2.0);
        }
        if (meta == 1) {
            return new AxisAlignedBB(p * 14.0, -1.0 + this.getBlockBelowHeight(world, pos), p * 5.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, p * 11.0);
        }
        if (meta == 2) {
            return new AxisAlignedBB(p * 5.0, -1.0 + this.getBlockBelowHeight(world, pos), p * 14.0, p * 11.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
        }
        if (meta == 3) {
            return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), p * 5.0, p * 2.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, p * 11.0);
        }
        return new AxisAlignedBB(0.0, -1.0 + this.getBlockBelowHeight(world, pos), 0.0, 1.0, -1.0 + this.getBlockBelowHeight(world, pos) + 1.0, 1.0);
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XYZ;
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        double offset = 1.0 - this.getBlockBelowHeight(worldIn, pos);
        return new Vec3d(0.0, -offset, 0.0);
    }

    public double getBlockBelowHeight(IBlockAccess worldIn, BlockPos pos) {
        IBlockState underState = worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
        Block underBlock = underState.func_177230_c();
        double extraOffset = 0.0;
        if (underBlock instanceof PaintBlockBase || underBlock instanceof NonPaintRoadTopBlock || underBlock instanceof CurbBlock) {
            extraOffset = 0.062;
        }
        return underBlock.func_185496_a((IBlockState)underState, (IBlockAccess)worldIn, (BlockPos)pos.func_177972_a((EnumFacing)EnumFacing.DOWN)).field_72337_e - extraOffset;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

