/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.silvaniastudios.roads.blocks.NonPaintRoadTopBlock;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BollardBlock
extends NonPaintRoadTopBlock
implements IMetaBlockName {
    public static final PropertyBool ROTATED = PropertyBool.func_177716_a((String)"rotated");
    public static final PropertyEnum<EnumBollard> BOLLARD_TYPE = PropertyEnum.func_177709_a((String)"type", EnumBollard.class);

    public BollardBlock(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ROTATED, (Comparable)Boolean.valueOf(false)).func_177226_a(BOLLARD_TYPE, (Comparable)((Object)EnumBollard.ID_0)));
        this.setHarvestLevel("pickaxe", 1);
        this.func_149715_a(12.0f);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int rot = 0;
        if (placer.func_174811_aO() == EnumFacing.EAST || placer.func_174811_aO() == EnumFacing.WEST) {
            rot = 1;
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta + rot, placer);
    }

    public int func_176201_c(IBlockState state) {
        ((EnumBollard)((Object)state.func_177229_b(BOLLARD_TYPE))).getMeta();
        int rot = 0;
        if (((Boolean)state.func_177229_b((IProperty)ROTATED)).equals(true)) {
            rot = 1;
        }
        return rot + ((EnumBollard)((Object)state.func_177229_b(BOLLARD_TYPE))).getMeta();
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 4));
        list.add((Object)new ItemStack((Block)this, 1, 6));
    }

    public int func_180651_a(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta % 2 == 1) {
            return meta - 1;
        }
        return meta;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.25, -1.0 + this.getBlockBelowHeight(worldIn, pos), 0.25, 0.75, -1.0 + this.getBlockBelowHeight(worldIn, pos) + 1.0, 0.75);
    }

    @Override
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.25, -1.0 + this.getBlockBelowHeight(worldIn, pos), 0.25, 0.75, -1.0 + this.getBlockBelowHeight(worldIn, pos) + 1.5, 0.75);
    }

    public IBlockState func_176203_a(int meta) {
        boolean rot = false;
        if (meta % 2 == 1) {
            rot = true;
            --meta;
        }
        return this.func_176223_P().func_177226_a((IProperty)ROTATED, (Comparable)Boolean.valueOf(rot)).func_177226_a(BOLLARD_TYPE, (Comparable)((Object)EnumBollard.byId(meta / 2)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ROTATED, BOLLARD_TYPE});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < 8; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)(i * 2), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory_" + i));
        }
    }

    public static enum EnumBollard implements IStringSerializable
    {
        ID_0(0, "0"),
        ID_1(2, "1"),
        ID_2(4, "2"),
        ID_3(6, "3"),
        ID_4(8, "4"),
        ID_5(10, "5"),
        ID_6(12, "6"),
        ID_7(14, "7");

        private final String name;
        private final int meta;

        private EnumBollard(int meta, String name) {
            this.name = name;
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static EnumBollard byId(int id) {
            if (id == 1) {
                return ID_1;
            }
            if (id == 2) {
                return ID_2;
            }
            if (id == 3) {
                return ID_3;
            }
            if (id == 4) {
                return ID_4;
            }
            if (id == 5) {
                return ID_5;
            }
            if (id == 6) {
                return ID_6;
            }
            if (id == 7) {
                return ID_7;
            }
            return ID_0;
        }
    }
}

