/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks;

import com.google.common.base.Predicate;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RoadBlockDiagonal
extends BlockBase {
    public static final PropertyEnum<EnumFacing> FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    boolean mirror;

    public RoadBlockDiagonal(String name, boolean mirror) {
        super(name, Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(FACING, (Comparable)EnumFacing.NORTH));
        this.mirror = mirror;
        this.func_149647_a(FurenikusRoads.tab_roads);
        this.setHarvestLevel("pneumatic_drill", 0);
        this.func_149711_c(1.0f);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (placer.func_174811_aO() == EnumFacing.NORTH) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.NORTH);
        }
        if (placer.func_174811_aO() == EnumFacing.EAST) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.EAST);
        }
        if (placer.func_174811_aO() == EnumFacing.SOUTH) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.SOUTH);
        }
        if (placer.func_174811_aO() == EnumFacing.WEST) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.WEST);
        }
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public int func_176201_c(IBlockState state) {
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.NORTH)) {
            return 0;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.EAST)) {
            return 1;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.SOUTH)) {
            return 2;
        }
        if (((EnumFacing)state.func_177229_b(FACING)).equals((Object)EnumFacing.WEST)) {
            return 3;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.NORTH);
        }
        if (meta == 1) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.EAST);
        }
        if (meta == 2) {
            return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.SOUTH);
        }
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.WEST);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public double getBlockHeight(IBlockAccess world, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        return block.func_185496_a((IBlockState)state, (IBlockAccess)world, (BlockPos)pos).field_72337_e;
    }

    public IBlockState getRoad(IBlockAccess world, BlockPos pos) {
        return this.getBlockSide(world, pos, this.mirror);
    }

    public BlockPos getRoadPos(IBlockAccess world, BlockPos pos) {
        return this.getSidePos(pos, world.func_180495_p(pos), this.mirror);
    }

    public IBlockState getSidewalk(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getBlockSide(world, pos, !this.mirror);
    }

    public IBlockState getBlockSide(IBlockAccess world, BlockPos pos, boolean left) {
        IBlockState thisState = world.func_180495_p(pos);
        return world.func_180495_p(this.getSidePos(pos, thisState, left));
    }

    public BlockPos getSidePos(BlockPos pos, IBlockState state, boolean left) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        if (facing == EnumFacing.NORTH) {
            return left ? pos.func_177972_a(EnumFacing.WEST) : pos.func_177972_a(EnumFacing.EAST);
        }
        if (facing == EnumFacing.EAST) {
            return left ? pos.func_177972_a(EnumFacing.SOUTH) : pos.func_177972_a(EnumFacing.NORTH);
        }
        if (facing == EnumFacing.SOUTH) {
            return left ? pos.func_177972_a(EnumFacing.EAST) : pos.func_177972_a(EnumFacing.WEST);
        }
        return left ? pos.func_177972_a(EnumFacing.NORTH) : pos.func_177972_a(EnumFacing.SOUTH);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

