/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.google.common.base.Predicate;
import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.enums.EnumConnectArrows;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.ArrowDiagonalPaintBlock;
import com.silvaniastudios.roads.blocks.paint.ArrowPaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArrowLinePaintBlock
extends PaintBlockBase
implements IMetaBlockName {
    public static final PropertyEnum<EnumConnectArrows> CONNECT = PropertyEnum.func_177709_a((String)"connect", EnumConnectArrows.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public ArrowLinePaintBlock(String name) {
        super(name);
        this.func_149647_a(FurenikusRoads.tab_paint_icons);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONNECT, (Comparable)((Object)EnumConnectArrows.CONNECT_NONE)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing == EnumFacing.DOWN || enumfacing == EnumFacing.UP) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    private EnumConnectArrows canLineConnectTo(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState stateEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        IBlockState stateSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState stateWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        BlockPos posNorth = pos.func_177972_a(EnumFacing.NORTH);
        BlockPos posSouth = pos.func_177972_a(EnumFacing.SOUTH);
        boolean blockNorth = stateNorth.func_177230_c() instanceof ArrowPaintBlock || stateNorth.func_177230_c() instanceof ArrowLinePaintBlock;
        boolean blockEast = stateEast.func_177230_c() instanceof ArrowPaintBlock || stateEast.func_177230_c() instanceof ArrowLinePaintBlock;
        boolean blockSouth = stateSouth.func_177230_c() instanceof ArrowPaintBlock || stateSouth.func_177230_c() instanceof ArrowLinePaintBlock;
        boolean blockWest = stateWest.func_177230_c() instanceof ArrowPaintBlock || stateWest.func_177230_c() instanceof ArrowLinePaintBlock;
        boolean blockNorthEast = world.func_180495_p(posNorth.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof ArrowDiagonalPaintBlock;
        boolean blockNorthWest = world.func_180495_p(posNorth.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof ArrowDiagonalPaintBlock;
        boolean blockSouthEast = world.func_180495_p(posSouth.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof ArrowDiagonalPaintBlock;
        boolean blockSouthWest = world.func_180495_p(posSouth.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof ArrowDiagonalPaintBlock;
        boolean blockUp = false;
        boolean blockLeft = false;
        boolean blockRight = false;
        boolean blockUpLeft = false;
        boolean blockUpRight = false;
        if (this.func_176201_c(state) == 2) {
            blockUp = blockNorth;
            blockLeft = blockWest;
            blockRight = blockEast;
            blockUpLeft = blockNorthWest;
            blockUpRight = blockNorthEast;
        }
        if (this.func_176201_c(state) == 5) {
            blockUp = blockEast;
            blockLeft = blockNorth;
            blockRight = blockSouth;
            blockUpLeft = blockNorthEast;
            blockUpRight = blockSouthEast;
        }
        if (this.func_176201_c(state) == 3) {
            blockUp = blockSouth;
            blockLeft = blockEast;
            blockRight = blockWest;
            blockUpLeft = blockSouthEast;
            blockUpRight = blockSouthWest;
        }
        if (this.func_176201_c(state) == 4) {
            blockUp = blockWest;
            blockLeft = blockSouth;
            blockRight = blockNorth;
            blockUpLeft = blockSouthWest;
            blockUpRight = blockNorthWest;
        }
        if (blockUpLeft) {
            return EnumConnectArrows.CONNECT_LEFT_DIAGONAL;
        }
        if (blockUpRight) {
            return EnumConnectArrows.CONNECT_RIGHT_DIAGONAL;
        }
        if (blockUp && blockRight && blockLeft) {
            return EnumConnectArrows.CONNECT_LEFT_RIGHT_UP;
        }
        if (blockUp && blockRight && !blockLeft) {
            return EnumConnectArrows.CONNECT_RIGHT_UP;
        }
        if (blockUp && !blockRight && blockLeft) {
            return EnumConnectArrows.CONNECT_LEFT_UP;
        }
        if (!blockUp && blockRight && blockLeft) {
            return EnumConnectArrows.CONNECT_LEFT_RIGHT;
        }
        if (!blockUp && !blockRight && blockLeft) {
            return EnumConnectArrows.CONNECT_LEFT;
        }
        if (!blockUp && blockRight && !blockLeft) {
            return EnumConnectArrows.CONNECT_RIGHT;
        }
        if (blockUp && !blockRight && !blockLeft) {
            return EnumConnectArrows.CONNECT_UP;
        }
        return EnumConnectArrows.CONNECT_NONE;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECT, FACING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECT, (Comparable)((Object)this.canLineConnectTo(worldIn, pos)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

