/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.crusher;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.crusher.CrusherContainer;
import com.silvaniastudios.roads.blocks.tileentities.crusher.CrusherStackHandler;
import com.silvaniastudios.roads.blocks.tileentities.recipes.CrusherRecipes;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CrusherEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int timerCount = 0;
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            CrusherEntity.this.func_70296_d();
        }
    };
    public CrusherStackHandler interactable_inv = new CrusherStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));

    public Container createContainer(EntityPlayer player) {
        return new CrusherContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(2).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(2));
                if (this.inventory.getStackInSlot(2).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(2, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(2, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
                return;
            }
        }
        if (this.timerCount < RoadsConfig.machine.crusherTickRate) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            this.process();
            this.timerCount = 0;
        }
    }

    public boolean shouldTick() {
        ItemStack itemOut;
        ItemStack itemIn = this.inventory.getStackInSlot(0);
        if (!itemIn.func_190926_b() && !(itemOut = this.getRecipes(itemIn)).func_190926_b()) {
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                return true;
            }
            if (this.inventory.getStackInSlot(1).func_77973_b() == itemOut.func_77973_b() && this.inventory.getStackInSlot(1).func_190916_E() + itemOut.func_190916_E() <= itemOut.func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public void process() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemOut;
            FurenikusRoads.debug(2, "Crusher at" + this.formatPosition(this.field_174879_c) + "processing");
            ItemStack itemIn = this.inventory.getStackInSlot(0);
            if (!itemIn.func_190926_b() && !(itemOut = this.getRecipes(itemIn)).func_190926_b()) {
                if (this.inventory.getStackInSlot(1).func_190926_b()) {
                    this.inventory.setStackInSlot(1, itemOut);
                    itemIn.func_190920_e(itemIn.func_190916_E() - 1);
                } else if (this.inventory.getStackInSlot(1).func_77973_b() == itemOut.func_77973_b() && this.inventory.getStackInSlot(1).func_190916_E() + itemOut.func_190916_E() <= itemOut.func_77976_d()) {
                    this.inventory.getStackInSlot(1).func_190920_e(this.inventory.getStackInSlot(1).func_190916_E() + itemOut.func_190916_E());
                    itemIn.func_190920_e(itemIn.func_190916_E() - 1);
                }
            }
        }
    }

    protected ItemStack getRecipes(ItemStack itemIn) {
        for (int i = 0; i < RecipeRegistry.crusherRecipes.size(); ++i) {
            CrusherRecipes recipe = RecipeRegistry.crusherRecipes.get(i);
            if (!recipe.test(itemIn)) continue;
            return recipe.getCraftingResult(this.inventory);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        return nbt;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.writeNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }
}

