/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.paintoven;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.fluids.FRFluids;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class PaintOvenEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public static final int FILLER_TANK_CAP = 64000;
    public int timerCount = 0;
    public ItemStackHandler inventory = new ItemStackHandler(2){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return PaintOvenEntity.this.isDye(stack, "dyeWhite") || PaintOvenEntity.this.isDye(stack, "dyeYellow") || PaintOvenEntity.this.isDye(stack, "dyeRed");
        }
    };
    public FluidTank water = new FluidTank(64000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid().getName().equalsIgnoreCase("water");
        }
    };
    public FluidTank paint = new FluidTank(64000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.white_paint || fluid.getFluid() == FRFluids.yellow_paint || fluid.getFluid() == FRFluids.red_paint;
        }
    };
    int lastPaint = 0;
    int lastWater = 0;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.water);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.paint);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (!this.inventory.getStackInSlot(1).func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(1));
                if (this.inventory.getStackInSlot(1).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(1, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(1, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
            }
        }
        if (this.timerCount < RoadsConfig.machine.paintOvenTickRate && this.fuel_remaining > 0) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            this.process();
            this.timerCount = 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.lastPaint == this.paint.getFluidAmount() && this.lastWater == this.water.getFluidAmount())) {
            this.lastPaint = this.paint.getFluidAmount();
            this.lastWater = this.water.getFluidAmount();
            this.sendUpdates();
        }
    }

    public void process() {
        FurenikusRoads.debug(2, "Paint Oven at" + this.formatPosition(this.field_174879_c) + "processing");
        if (!this.field_145850_b.field_72995_K) {
            if (this.water.getFluidAmount() >= 1000 && this.paint.getFluidAmount() + 1000 <= this.paint.getCapacity()) {
                int dyeCol = -1;
                boolean filled = false;
                ItemStack dye = this.inventory.getStackInSlot(0);
                if (this.isDye(dye, "dyeWhite")) {
                    dyeCol = 0;
                }
                if (this.isDye(dye, "dyeYellow")) {
                    dyeCol = 1;
                }
                if (this.isDye(dye, "dyeRed")) {
                    dyeCol = 2;
                }
                if (this.paint.getFluidAmount() > 0) {
                    if (dyeCol == 0 && this.paint.getFluid().getFluid() == FRFluids.white_paint) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.white_paint, 1000), true);
                        filled = true;
                    } else if (dyeCol == 1 && this.paint.getFluid().getFluid() == FRFluids.yellow_paint) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.yellow_paint, 1000), true);
                        filled = true;
                    } else if (dyeCol == 2 && this.paint.getFluid().getFluid() == FRFluids.red_paint) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.red_paint, 1000), true);
                        filled = true;
                    }
                } else {
                    if (dyeCol == 0) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.white_paint, 1000), true);
                        filled = true;
                    }
                    if (dyeCol == 1) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.yellow_paint, 1000), true);
                        filled = true;
                    }
                    if (dyeCol == 2) {
                        this.paint.fill(new FluidStack((Fluid)FRFluids.red_paint, 1000), true);
                        filled = true;
                    }
                }
                if (filled) {
                    this.water.drain(1000, true);
                    this.inventory.extractItem(0, 1, false);
                }
            }
            this.sendUpdates();
        }
    }

    public boolean shouldTick() {
        return this.water.getFluidAmount() >= 1000 && (this.fuel_remaining > 0 || this.hasCapability(CapabilityEnergy.ENERGY, null)) && this.inventory.getStackInSlot(0).func_190916_E() >= 1 && this.paint.getFluidAmount() + 1000 <= this.paint.getCapacity();
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        if (nbt.func_74764_b("water")) {
            this.water.readFromNBT((NBTTagCompound)nbt.func_74781_a("water"));
        }
        if (nbt.func_74764_b("paint")) {
            this.paint.readFromNBT((NBTTagCompound)nbt.func_74781_a("paint"));
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74782_a("water", (NBTBase)this.water.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("paint", (NBTBase)this.paint.writeToNBT(new NBTTagCompound()));
        return nbt;
    }
}

