/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.roadfactory;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RoadFactoryRecipes;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryBlock;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryContainer;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryStackHandler;
import com.silvaniastudios.roads.fluids.FRFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RoadFactoryEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int timerCount = 0;
    public int fillCheckTick = 0;
    public int previousFill = 0;
    public boolean isFilling = false;
    public static final int TANK_CAP = 320000;
    public ItemStackHandler inventory = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            RoadFactoryEntity.this.func_70296_d();
        }
    };
    public RoadFactoryStackHandler interactable_inv = new RoadFactoryStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));
    public FluidTank tarFluid = new FluidTank(320000){

        public boolean canFillFluidType(FluidStack fluid) {
            for (int i = 0; i < RoadsConfig.general.tarAlternatives.length; ++i) {
                if (!RoadsConfig.general.tarAlternatives[i].equalsIgnoreCase(fluid.getFluid().getName())) continue;
                return true;
            }
            return fluid.getFluid() == FRFluids.tar;
        }
    };
    int lastTar = 0;

    public Container createContainer(EntityPlayer player) {
        return new RoadFactoryContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            EnumFacing sideLeft = EnumFacing.WEST;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof RoadFactoryBlock) {
                RoadFactoryBlock block = (RoadFactoryBlock)state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (meta == 1) {
                    sideLeft = EnumFacing.NORTH;
                }
                if (meta == 2) {
                    sideLeft = EnumFacing.EAST;
                }
                if (meta == 3) {
                    sideLeft = EnumFacing.SOUTH;
                }
                if (facing == sideLeft || facing == EnumFacing.UP) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tarFluid);
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        this.renderUpdate();
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            ItemStack fuel = this.inventory.getStackInSlot(8);
            if (!fuel.func_190926_b()) {
                this.last_fuel_cap = this.fuel_remaining = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                if (this.inventory.getStackInSlot(8).func_77973_b() == Items.field_151129_at) {
                    this.inventory.setStackInSlot(8, new ItemStack(Items.field_151133_ar));
                } else {
                    this.inventory.extractItem(8, 1, false);
                }
                this.sendUpdates();
            } else {
                this.timerCount = 0;
                return;
            }
        }
        if (this.timerCount < RoadsConfig.machine.roadFactoryTickRate) {
            if (this.shouldTick()) {
                ++this.timerCount;
                this.fillCheckTick = this.timerCount;
            } else {
                this.timerCount = 0;
            }
        } else {
            this.process();
            this.timerCount = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.lastTar != this.tarFluid.getFluidAmount()) {
            this.lastTar = this.tarFluid.getFluidAmount();
            this.sendUpdates();
        }
    }

    public void extract(int iterations) {
        for (int i = 0; i < iterations; ++i) {
            if (this.inventory.extractItem(0, 8, false) != ItemStack.field_190927_a || this.inventory.extractItem(1, 8, false) != ItemStack.field_190927_a || this.inventory.extractItem(2, 8, false) != ItemStack.field_190927_a || this.inventory.extractItem(3, 8, false) != ItemStack.field_190927_a) continue;
            FurenikusRoads.debug(0, "WARNING! A road factory is creating free resources. Please report to Fureniku https://discord.gg/BPzpQk2");
        }
    }

    public void process() {
        FurenikusRoads.debug(2, "Road Factory at" + this.formatPosition(this.field_174879_c) + "processing");
        if (!this.field_145850_b.field_72995_K) {
            boolean hasChanges = false;
            ItemStack result = this.getRecipeResult();
            if (result != ItemStack.field_190927_a && this.tarFluid.getFluidAmount() >= 100 * result.func_190916_E() / 8) {
                if (result.func_190916_E() == 8) {
                    this.extract(1);
                } else if (result.func_190916_E() == 16) {
                    this.extract(2);
                } else if (result.func_190916_E() == 24) {
                    this.extract(3);
                } else if (result.func_190916_E() == 32) {
                    this.extract(4);
                }
                this.putItemsInSlot(result, false);
                hasChanges = true;
                this.tarFluid.drain(new FluidStack(this.tarFluid.getFluid().getFluid(), 100 * result.func_190916_E() / 8), true);
            }
            ItemStack fluid_in = this.inventory.getStackInSlot(9);
            ItemStack bucket_out = this.inventory.getStackInSlot(10);
            if (fluid_in.func_77977_a().compareTo("item.forge.bucketFilled") == 0) {
                FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)fluid_in);
                for (int i = 0; i < RecipeRegistry.tar.size(); ++i) {
                    if (RecipeRegistry.tar.get(i).getFluid() != fluidStack.getFluid() || this.tarFluid.fill(fluidStack, false) != fluidStack.amount) continue;
                    if (this.tarFluid.getFluidAmount() > 320000 - fluidStack.amount || !bucket_out.func_190926_b() && bucket_out.func_190916_E() >= bucket_out.func_77976_d()) break;
                    this.tarFluid.fill(fluidStack, true);
                    this.inventory.setStackInSlot(9, ItemStack.field_190927_a);
                    if (bucket_out.func_190926_b()) {
                        this.inventory.setStackInSlot(10, new ItemStack(Items.field_151133_ar));
                    } else {
                        bucket_out.func_190920_e(bucket_out.func_190916_E() + 1);
                    }
                    hasChanges = true;
                    break;
                }
            }
            if (hasChanges) {
                this.sendUpdates();
            }
        }
    }

    public void renderUpdate() {
        if (this.field_145850_b.field_72995_K) {
            if (this.fillCheckTick < RoadsConfig.machine.roadFactoryTickRate) {
                ++this.fillCheckTick;
            } else {
                if (this.previousFill < this.tarFluid.getFluidAmount()) {
                    this.previousFill = this.tarFluid.getFluidAmount();
                    this.isFilling = true;
                } else {
                    this.isFilling = false;
                }
                this.fillCheckTick = 0;
            }
        }
    }

    public boolean shouldTick() {
        if (this.tarFluid.getFluidAmount() >= 100 && this.getRecipeResult() != ItemStack.field_190927_a) {
            return true;
        }
        ItemStack fluid_in = this.inventory.getStackInSlot(9);
        ItemStack bucket_out = this.inventory.getStackInSlot(10);
        return fluid_in.func_77977_a().compareTo("item.forge.bucketFilled") == 0 && this.tarFluid.getFluidAmount() <= 319900 && (bucket_out.func_190926_b() || bucket_out.func_190916_E() < bucket_out.func_77976_d());
    }

    public ItemStack getRecipeResult() {
        for (int i = 0; i < RecipeRegistry.roadFactoryRecipes.size(); ++i) {
            RoadFactoryRecipes recipe = RecipeRegistry.roadFactoryRecipes.get(i);
            ItemStack out = recipe.getCraftingResult(this.inventory);
            ItemStack sim = out.func_77946_l();
            if (out == ItemStack.field_190927_a) continue;
            if ((sim = this.inventory.insertItem(4, sim, true)) != ItemStack.field_190927_a) {
                sim = this.inventory.insertItem(5, sim, true);
            }
            if (sim != ItemStack.field_190927_a) {
                sim = this.inventory.insertItem(6, sim, true);
            }
            if (sim != ItemStack.field_190927_a) {
                sim = this.inventory.insertItem(7, sim, true);
            }
            if (sim != ItemStack.field_190927_a) continue;
            return out;
        }
        return ItemStack.field_190927_a;
    }

    public void putItemsInSlot(ItemStack stack, boolean simulate) {
        if (stack != ItemStack.field_190927_a) {
            stack = this.inventory.insertItem(4, stack, false);
        }
        if (stack != ItemStack.field_190927_a) {
            stack = this.inventory.insertItem(5, stack, false);
        }
        if (stack != ItemStack.field_190927_a) {
            stack = this.inventory.insertItem(6, stack, false);
        }
        if (stack != ItemStack.field_190927_a) {
            stack = this.inventory.insertItem(7, stack, false);
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        this.fuel_remaining = nbt.func_74762_e("fuel");
        this.last_fuel_cap = nbt.func_74762_e("fuel_last_used");
        this.tarFluid.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74768_a("fuel", this.fuel_remaining);
        nbt.func_74768_a("fuel_last_used", this.last_fuel_cap);
        this.tarFluid.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.writeNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }
}

