/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model;

import com.silvaniastudios.roads.blocks.CatsEyeBlock;
import com.silvaniastudios.roads.blocks.CatsEyeBlockFourWay;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.client.model.CatsEyeDoubleModel;
import com.silvaniastudios.roads.client.model.CatsEyeModel;
import com.silvaniastudios.roads.client.model.CatsEyeTwoSidedDoubleModel;
import com.silvaniastudios.roads.client.model.CatsEyeTwoSidedModel;
import com.silvaniastudios.roads.client.model.CrusherBakedModel;
import com.silvaniastudios.roads.client.model.PaintFillerBakedModel;
import com.silvaniastudios.roads.client.model.PaintGunModel;
import com.silvaniastudios.roads.client.model.RoadFactoryBakedModel;
import com.silvaniastudios.roads.client.model.TarDistillerBakedModel;
import com.silvaniastudios.roads.client.model.TarmacCutterBakedModel;
import com.silvaniastudios.roads.items.PaintGunItemRegistry;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelBakeHandler {
    public static final ModelBakeHandler instance = new ModelBakeHandler();

    private ModelBakeHandler() {
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.bakePaintGunModel(event);
        this.bakeCatsEyeModels(event);
        this.bakeCatsEyeDoubleSidedModels(event);
        this.bakeCrusherFurnace(event);
        this.bakePaintFillerFurnace(event);
        this.bakeRoadFactoryFurnace(event);
        this.bakeTarDistillerFurnace(event);
        this.bakeTarmacCutterFurnace(event);
    }

    private void bakePaintGunModel(ModelBakeEvent event) {
        Object model = event.getModelRegistry().func_82594_a((Object)PaintGunModel.modelResourceLocation);
        if (model instanceof IBakedModel) {
            IBakedModel existingModel = (IBakedModel)model;
            PaintGunModel customModel = new PaintGunModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)PaintGunModel.modelResourceLocation, (Object)customModel);
        }
    }

    private void bakeDiagonalRoads(ModelBakeEvent event) {
        String[] facing = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < facing.length; ++i) {
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:road_block_diagonal_1_1", "facing=" + facing[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            if (!(model instanceof IBakedModel)) continue;
            IBakedModel existingModel = (IBakedModel)model;
            CrusherBakedModel customModel = new CrusherBakedModel(existingModel, facing[i]);
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
        }
    }

    private void bakeCatsEyeDoubleSidedModels(ModelBakeEvent event) {
        String[] catsEyeList = new String[]{"cats_eye_red_green", "cats_eye_white_red", "cats_eye_white_yellow", "cats_eye_white_green", "cats_eye_yellow_red"};
        for (int i = 0; i < catsEyeList.length; ++i) {
            String l = "red";
            String r = "green";
            if (i == 1 || i == 2 || i == 3) {
                l = "white";
            }
            if (i == 1) {
                r = "red";
            }
            if (i == 2) {
                r = "yellow";
            }
            if (i == 3) {
                r = "green";
            }
            if (i == 4) {
                l = "yellow";
                r = "red";
            }
            for (int j = 0; j < CatsEyeBlockFourWay.EnumCatsEye.values().length; ++j) {
                ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:" + catsEyeList[i], "eye_type=" + (Object)((Object)CatsEyeBlockFourWay.EnumCatsEye.byMetadata(j)));
                Object cats_eye = event.getModelRegistry().func_82594_a((Object)mrl);
                if (cats_eye instanceof IBakedModel) {
                    IBakedModel existingModel = (IBakedModel)cats_eye;
                    CatsEyeTwoSidedModel customModel = new CatsEyeTwoSidedModel(existingModel, l, r, CatsEyeBlockFourWay.EnumCatsEye.byMetadata(j));
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
                }
                ModelResourceLocation mrl_double = new ModelResourceLocation("furenikusroads:" + catsEyeList[i] + "_double", "eye_type=" + (Object)((Object)CatsEyeBlockFourWay.EnumCatsEye.byMetadata(j)));
                Object cats_eye_double = event.getModelRegistry().func_82594_a((Object)mrl_double);
                if (!(cats_eye_double instanceof IBakedModel)) continue;
                IBakedModel existingModel = (IBakedModel)cats_eye_double;
                CatsEyeTwoSidedDoubleModel customModel = new CatsEyeTwoSidedDoubleModel(existingModel, l, r, CatsEyeBlockFourWay.EnumCatsEye.byMetadata(j));
                event.getModelRegistry().func_82595_a((Object)mrl_double, (Object)customModel);
            }
        }
    }

    private void bakeCatsEyeModels(ModelBakeEvent event) {
        String[] catsEyeList = new String[]{"cats_eye_white", "cats_eye_yellow", "cats_eye_red", "cats_eye_green", "cats_eye_blue"};
        String[] colourList = new String[]{"white", "yellow", "red", "green", "blue"};
        for (int i = 0; i < catsEyeList.length; ++i) {
            for (int j = 0; j < CatsEyeBlock.EnumCatsEye.values().length; ++j) {
                ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:" + catsEyeList[i], "eye_type=" + (Object)((Object)CatsEyeBlock.EnumCatsEye.byMetadata(j)));
                Object cats_eye = event.getModelRegistry().func_82594_a((Object)mrl);
                if (cats_eye instanceof IBakedModel) {
                    IBakedModel existingModel = (IBakedModel)cats_eye;
                    CatsEyeModel customModel = new CatsEyeModel(existingModel, colourList[i], CatsEyeBlock.EnumCatsEye.byMetadata(j));
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
                }
                ModelResourceLocation mrl_double = new ModelResourceLocation("furenikusroads:" + catsEyeList[i] + "_double", "eye_type=" + (Object)((Object)CatsEyeBlock.EnumCatsEye.byMetadata(j)));
                Object cats_eye_double = event.getModelRegistry().func_82594_a((Object)mrl_double);
                if (!(cats_eye_double instanceof IBakedModel)) continue;
                IBakedModel existingModel = (IBakedModel)cats_eye_double;
                CatsEyeDoubleModel customModel = new CatsEyeDoubleModel(existingModel, colourList[i], CatsEyeBlock.EnumCatsEye.byMetadata(j));
                event.getModelRegistry().func_82595_a((Object)mrl_double, (Object)customModel);
            }
        }
    }

    private void bakeCrusherFurnace(ModelBakeEvent event) {
        String[] rotations = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < rotations.length; ++i) {
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:crusher", "furnace_active=true,rotation=" + rotations[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            if (!(model instanceof IBakedModel)) continue;
            IBakedModel existingModel = (IBakedModel)model;
            CrusherBakedModel customModel = new CrusherBakedModel(existingModel, rotations[i]);
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
        }
    }

    private void bakePaintFillerFurnace(ModelBakeEvent event) {
        String[] rotations = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < rotations.length; ++i) {
            PaintFillerBakedModel customModel;
            IBakedModel existingModel;
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:paint_filler", "furnace_active=true,gun_loaded=false,rotation=" + rotations[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            ModelResourceLocation mrl_gunloaded = new ModelResourceLocation("furenikusroads:paint_filler", "furnace_active=true,gun_loaded=true,rotation=" + rotations[i]);
            Object model_gunloaded = event.getModelRegistry().func_82594_a((Object)mrl_gunloaded);
            if (model instanceof IBakedModel) {
                existingModel = (IBakedModel)model;
                customModel = new PaintFillerBakedModel(existingModel, rotations[i], false);
                if (((IBakedModel)model).func_177554_e() != null) {
                    event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
                }
            }
            if (!(model_gunloaded instanceof IBakedModel)) continue;
            existingModel = (IBakedModel)model_gunloaded;
            customModel = new PaintFillerBakedModel(existingModel, rotations[i], true);
            if (((IBakedModel)model).func_177554_e() == null) continue;
            event.getModelRegistry().func_82595_a((Object)mrl_gunloaded, (Object)customModel);
        }
    }

    private void bakeRoadFactoryFurnace(ModelBakeEvent event) {
        String[] rotations = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < rotations.length; ++i) {
            RoadFactoryBakedModel customModel;
            IBakedModel existingModel;
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:road_factory", "connected=false,furnace_active=true,rotation=" + rotations[i]);
            ModelResourceLocation mrl_connect = new ModelResourceLocation("furenikusroads:road_factory", "connected=true,furnace_active=true,rotation=" + rotations[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            Object model_connect = event.getModelRegistry().func_82594_a((Object)mrl_connect);
            if (model instanceof IBakedModel) {
                existingModel = (IBakedModel)model;
                customModel = new RoadFactoryBakedModel(existingModel, rotations[i]);
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
            }
            if (!(model_connect instanceof IBakedModel)) continue;
            existingModel = (IBakedModel)model_connect;
            customModel = new RoadFactoryBakedModel(existingModel, rotations[i]);
            event.getModelRegistry().func_82595_a((Object)mrl_connect, (Object)customModel);
        }
    }

    private void bakeTarDistillerFurnace(ModelBakeEvent event) {
        String[] rotations = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < rotations.length; ++i) {
            TarDistillerBakedModel customModel;
            IBakedModel existingModel;
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:tar_distiller", "connected=false,furnace_active=true,rotation=" + rotations[i]);
            ModelResourceLocation mrl_connect = new ModelResourceLocation("furenikusroads:tar_distiller", "connected=true,furnace_active=true,rotation=" + rotations[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            Object model_connect = event.getModelRegistry().func_82594_a((Object)mrl_connect);
            if (model instanceof IBakedModel) {
                existingModel = (IBakedModel)model;
                customModel = new TarDistillerBakedModel(existingModel, rotations[i]);
                event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
            }
            if (!(model_connect instanceof IBakedModel)) continue;
            existingModel = (IBakedModel)model_connect;
            customModel = new TarDistillerBakedModel(existingModel, rotations[i]);
            event.getModelRegistry().func_82595_a((Object)mrl_connect, (Object)customModel);
        }
    }

    private void bakeTarmacCutterFurnace(ModelBakeEvent event) {
        String[] rotations = new String[]{"north", "east", "south", "west"};
        for (int i = 0; i < rotations.length; ++i) {
            ModelResourceLocation mrl = new ModelResourceLocation("furenikusroads:tarmac_cutter", "furnace_active=true,rotation=" + rotations[i]);
            Object model = event.getModelRegistry().func_82594_a((Object)mrl);
            if (!(model instanceof IBakedModel)) continue;
            IBakedModel existingModel = (IBakedModel)model;
            TarmacCutterBakedModel customModel = new TarmacCutterBakedModel(existingModel, rotations[i]);
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)customModel);
        }
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        ResourceLocation sprite;
        String name;
        int j;
        PaintBlockBase block;
        int i;
        ResourceLocation white_paint = new ResourceLocation("furenikusroads:items/paint_white");
        ResourceLocation yellow_paint = new ResourceLocation("furenikusroads:items/paint_yellow");
        ResourceLocation red_paint = new ResourceLocation("furenikusroads:items/paint_red");
        ResourceLocation tar_flowing = new ResourceLocation("furenikusroads:fluids/tar_flowing");
        ResourceLocation tar_still = new ResourceLocation("furenikusroads:fluids/tar_still");
        ResourceLocation white_paint_flowing = new ResourceLocation("furenikusroads:fluids/white_paint_flowing");
        ResourceLocation white_paint_still = new ResourceLocation("furenikusroads:fluids/white_paint_still");
        ResourceLocation yellow_paint_flowing = new ResourceLocation("furenikusroads:fluids/yellow_paint_flowing");
        ResourceLocation yellow_paint_still = new ResourceLocation("furenikusroads:fluids/yellow_paint_still");
        ResourceLocation red_paint_flowing = new ResourceLocation("furenikusroads:fluids/red_paint_flowing");
        ResourceLocation red_paint_still = new ResourceLocation("furenikusroads:fluids/red_paint_still");
        ResourceLocation cats_eye_white = new ResourceLocation("furenikusroads:blocks/cats_eye_white");
        ResourceLocation cats_eye_yellow = new ResourceLocation("furenikusroads:blocks/cats_eye_yellow");
        ResourceLocation cats_eye_red = new ResourceLocation("furenikusroads:blocks/cats_eye_red");
        ResourceLocation cats_eye_green = new ResourceLocation("furenikusroads:blocks/cats_eye_green");
        ResourceLocation machine_vent_on = new ResourceLocation("furenikusroads:blocks/machine_vent_back_on");
        ResourceLocation paint_filler_display = new ResourceLocation("furenikusroads:blocks/paint_filler_machine_display");
        ResourceLocation sprite_white_paint = new ResourceLocation("furenikusroads:fluids/white_paint_flowing");
        ResourceLocation sprite_yellow_paint = new ResourceLocation("furenikusroads:fluids/yellow_paint_flowing");
        ResourceLocation sprite_red_paint = new ResourceLocation("furenikusroads:fluids/red_paint_flowing");
        ResourceLocation sprite_glass = new ResourceLocation("furenikusroads:blocks/hopper_tank");
        ResourceLocation sprite_glass_top = new ResourceLocation("furenikusroads:blocks/hopper_tank_top");
        ResourceLocation sprite_light_white = new ResourceLocation("furenikusroads:blocks/hopper_type_white");
        ResourceLocation sprite_light_yellow = new ResourceLocation("furenikusroads:blocks/hopper_type_yellow");
        ResourceLocation sprite_light_red = new ResourceLocation("furenikusroads:blocks/hopper_type_red");
        ResourceLocation sprite_light_item = new ResourceLocation("furenikusroads:blocks/hopper_type_item");
        ResourceLocation sprite_light_none = new ResourceLocation("furenikusroads:blocks/hopper_type_none");
        event.getMap().func_174942_a(white_paint);
        event.getMap().func_174942_a(yellow_paint);
        event.getMap().func_174942_a(red_paint);
        event.getMap().func_174942_a(tar_flowing);
        event.getMap().func_174942_a(tar_still);
        event.getMap().func_174942_a(white_paint_flowing);
        event.getMap().func_174942_a(white_paint_still);
        event.getMap().func_174942_a(yellow_paint_flowing);
        event.getMap().func_174942_a(yellow_paint_still);
        event.getMap().func_174942_a(red_paint_flowing);
        event.getMap().func_174942_a(red_paint_still);
        event.getMap().func_174942_a(cats_eye_white);
        event.getMap().func_174942_a(cats_eye_yellow);
        event.getMap().func_174942_a(cats_eye_red);
        event.getMap().func_174942_a(cats_eye_green);
        event.getMap().func_174942_a(machine_vent_on);
        event.getMap().func_174942_a(paint_filler_display);
        event.getMap().func_174942_a(sprite_white_paint);
        event.getMap().func_174942_a(sprite_yellow_paint);
        event.getMap().func_174942_a(sprite_red_paint);
        event.getMap().func_174942_a(sprite_glass);
        event.getMap().func_174942_a(sprite_glass_top);
        event.getMap().func_174942_a(sprite_light_white);
        event.getMap().func_174942_a(sprite_light_yellow);
        event.getMap().func_174942_a(sprite_light_red);
        event.getMap().func_174942_a(sprite_light_item);
        event.getMap().func_174942_a(sprite_light_none);
        for (i = 0; i < PaintGunItemRegistry.lines.size(); ++i) {
            block = PaintGunItemRegistry.lines.get(i);
            for (j = 0; j < 3; ++j) {
                if (j == 1) {
                    block = PaintGunItemRegistry.getYellow(block);
                }
                if (j == 2) {
                    block = PaintGunItemRegistry.getRed(block);
                }
                name = block.func_149739_a().substring(20);
                if (PaintGunItemRegistry.linesMeta.get(i) > 0) {
                    name = name + "_" + PaintGunItemRegistry.linesMeta.get(i);
                }
                sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
        for (i = 0; i < PaintGunItemRegistry.icons.size(); ++i) {
            block = PaintGunItemRegistry.icons.get(i);
            for (j = 0; j < 3; ++j) {
                if (j == 1) {
                    block = PaintGunItemRegistry.getYellow(block);
                }
                if (j == 2) {
                    block = PaintGunItemRegistry.getRed(block);
                }
                name = block.func_149739_a().substring(20);
                if (PaintGunItemRegistry.iconsMeta.get(i) > 0) {
                    name = name + "_" + PaintGunItemRegistry.iconsMeta.get(i);
                }
                sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
        for (i = 0; i < PaintGunItemRegistry.letters.size(); ++i) {
            block = PaintGunItemRegistry.letters.get(i);
            for (j = 0; j < 3; ++j) {
                if (j == 1) {
                    block = PaintGunItemRegistry.getYellow(block);
                }
                if (j == 2) {
                    block = PaintGunItemRegistry.getRed(block);
                }
                name = block.func_149739_a().substring(20);
                if (PaintGunItemRegistry.lettersMeta.get(i) > 0) {
                    name = name + "_" + PaintGunItemRegistry.lettersMeta.get(i);
                }
                sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
        for (i = 0; i < PaintGunItemRegistry.text.size(); ++i) {
            block = PaintGunItemRegistry.text.get(i);
            for (j = 0; j < 3; ++j) {
                if (j == 1) {
                    block = PaintGunItemRegistry.getYellow(block);
                }
                if (j == 2) {
                    block = PaintGunItemRegistry.getRed(block);
                }
                name = block.func_149739_a().substring(20);
                sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
        for (i = 0; i < PaintGunItemRegistry.junction.size(); ++i) {
            block = PaintGunItemRegistry.junction.get(i);
            for (j = 0; j < 3; ++j) {
                if (j == 1) {
                    block = PaintGunItemRegistry.getYellow(block);
                }
                if (j == 2) {
                    block = PaintGunItemRegistry.getRed(block);
                }
                name = block.func_149739_a().substring(20);
                if (PaintGunItemRegistry.junctionMeta.get(i) > 0) {
                    name = name + "_" + PaintGunItemRegistry.junctionMeta.get(i);
                }
                sprite = new ResourceLocation("furenikusroads:items/paint_gun_display/" + name);
                event.getMap().func_174942_a(sprite);
            }
        }
    }
}

