/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus;

import com.mojang.brigadier.CommandDispatcher;
import de.cas_ual_ty.guncus.IProxy;
import de.cas_ual_ty.guncus.client.ClientProxy;
import de.cas_ual_ty.guncus.command.GunCusCommand;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.itemgroup.GunCusItemGroup;
import de.cas_ual_ty.guncus.network.HitmarkerMessage;
import de.cas_ual_ty.guncus.network.MakerMessages;
import de.cas_ual_ty.guncus.network.ShootMessage;
import de.cas_ual_ty.guncus.registries.GunCusItems;
import de.cas_ual_ty.guncus.registries.GunCusPointOfInterestTypes;
import de.cas_ual_ty.guncus.registries.GunCusVillagerProfessions;
import de.cas_ual_ty.guncus.server.ServerProxy;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="guncus")
public class GunCus {
    public static final String MOD_ID = "guncus";
    public static final String PROTOCOL_VERSION = "2";
    public static GunCus instance;
    public static IProxy proxy;
    public static SimpleChannel channel;
    public static boolean FULL_CREATIVE_TABS;
    public static final GunCusItemGroup ITEM_GROUP_GUN_CUS;

    public GunCus() {
        instance = this;
        proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::init);
        proxy.registerModEventListeners(bus);
        bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::registerCommands);
        bus.addListener(this::villagerTrades);
        bus.addListener(this::wandererTrades);
        proxy.registerForgeEventListeners(bus);
    }

    public void init(FMLCommonSetupEvent event) {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MOD_ID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        channel.registerMessage(0, ShootMessage.class, ShootMessage::encode, ShootMessage::decode, ShootMessage::handle);
        channel.registerMessage(1, HitmarkerMessage.class, HitmarkerMessage::encode, HitmarkerMessage::decode, HitmarkerMessage::handle);
        channel.registerMessage(4, MakerMessages.Next.class, MakerMessages.Next::encode, MakerMessages.Next::decode, MakerMessages.Next::handle);
        channel.registerMessage(5, MakerMessages.Prev.class, MakerMessages.Prev::encode, MakerMessages.Prev::decode, MakerMessages.Prev::handle);
        channel.registerMessage(6, MakerMessages.Create.class, MakerMessages.Create::encode, MakerMessages.Create::decode, MakerMessages.Create::handle);
        GunCusUtility.fixPOITypeBlockStates(GunCusPointOfInterestTypes.ARMS_DEALER);
        proxy.init();
        for (GunItem gun : GunItem.ALL_GUNS_LIST) {
            if (gun.gunTab == null) continue;
            gun.gunTab.init();
        }
    }

    public void registerCommands(RegisterCommandsEvent event) {
        GunCusCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    public void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() == GunCusVillagerProfessions.ARMS_DEALER) {
            ((List)event.getTrades().get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 16), new ItemStack((IItemProvider)GunCusItems.GUN_TABLE), 8, 10, 0.0f));
            RandomTradeBuilder.forEachLevel((level, tradeBuild) -> ((List)event.getTrades().get(level.intValue())).add(tradeBuild.build()));
        }
    }

    public void wandererTrades(WandererTradesEvent event) {
        List genericList = event.getGenericTrades();
        RandomTradeBuilder.forEachWanderer(tradeBuild -> genericList.add(tradeBuild.build()));
        List rareList = event.getRareTrades();
        RandomTradeBuilder.forEachWandererRare(tradeBuild -> rareList.add(tradeBuild.build()));
    }

    public static void debug(String s) {
        System.out.println("guncus ----- " + s);
    }

    static {
        FULL_CREATIVE_TABS = false;
        ITEM_GROUP_GUN_CUS = new GunCusItemGroup(MOD_ID);
    }
}

