/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.IProxy;
import de.cas_ual_ty.guncus.client.BakedModelGun;
import de.cas_ual_ty.guncus.client.BakedModelOptic;
import de.cas_ual_ty.guncus.client.HitmarkerRenderer;
import de.cas_ual_ty.guncus.client.LaserRenderer;
import de.cas_ual_ty.guncus.client.SightRenderer;
import de.cas_ual_ty.guncus.client.gui.GunTableScreen;
import de.cas_ual_ty.guncus.client.gui.MakerScreen;
import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import de.cas_ual_ty.guncus.itemgroup.ShuffleItemGroup;
import de.cas_ual_ty.guncus.network.ShootMessage;
import de.cas_ual_ty.guncus.registries.GunCusContainerTypes;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.network.NetworkEvent;

public class ClientProxy
implements IProxy {
    private static int[] shootTime = new int[GunCusUtility.HANDS.length];
    private static int inaccuracyTime = 0;
    private static int prevSelectedMain = -1;
    private static boolean[] locked = new boolean[GunCusUtility.HANDS.length];

    @Override
    public void registerModEventListeners(IEventBus bus) {
        bus.addListener(this::modelBake);
        bus.addListener(this::modelRegistry);
    }

    @Override
    public void registerForgeEventListeners(IEventBus bus) {
        bus.addListener(this::clientTick);
        bus.register((Object)new HitmarkerRenderer());
        bus.register((Object)new LaserRenderer());
        bus.register((Object)new SightRenderer());
    }

    @Override
    public void init() {
        ScreenManager.func_216911_a(GunCusContainerTypes.GUN_TABLE, GunTableScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.GUN_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.BULLET_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.OPTIC_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.ACCESSORY_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.BARREL_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.UNDERBARREL_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.AUXILIARY_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.AMMO_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.MAGAZINE_MAKER, MakerScreen::new);
        ScreenManager.func_216911_a(GunCusContainerTypes.PAINT_MAKER, MakerScreen::new);
    }

    @Override
    public void addHitmarker(PlayerEntity player) {
        HitmarkerRenderer.addHitmarker();
    }

    @Override
    public PlayerEntity getPlayerFromContext(@Nullable NetworkEvent.Context context) {
        return ClientProxy.getClientPlayer();
    }

    @Override
    public void shot(ItemStack itemStack, GunItem gun, PlayerEntity player, Hand hand) {
        int fireRate = gun.calcCurrentFireRate(gun.getCurrentAttachments(itemStack));
        ClientProxy.shootTime[hand == Hand.MAIN_HAND ? 0 : 1] = fireRate;
        inaccuracyTime = Math.min(15, inaccuracyTime + 2 + fireRate);
    }

    public void modelBake(ModelBakeEvent event) {
        IBakedModel main;
        for (AttachmentItem attachment : AttachmentItem.ALL_ATTACHMENTS_LIST) {
            Optic optic;
            if (attachment.getType() != EnumAttachmentType.OPTIC || (optic = (Optic)attachment) == null || !optic.canAim() || optic.isDefault()) continue;
            ModelResourceLocation mrl = new ModelResourceLocation(optic.getRegistryName().toString(), "inventory");
            main = (IBakedModel)event.getModelRegistry().get(mrl);
            event.getModelRegistry().put(mrl, new BakedModelOptic(main));
        }
        for (GunItem gun : GunItem.ALL_GUNS_LIST) {
            IBakedModel[][] models = new IBakedModel[EnumAttachmentType.LENGTH][];
            for (EnumAttachmentType type : EnumAttachmentType.RENDER_ORDER) {
                int i = type.getSlot();
                models[i] = new IBakedModel[gun.getAmmountForSlot(type)];
                for (int j = 0; j < models[i].length; ++j) {
                    AttachmentItem attachment = gun.getAttachment(type, j);
                    if (attachment == null) continue;
                    models[i][j] = (IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
            main = models[EnumAttachmentType.PAINT.getSlot()][0];
            event.getModelRegistry().put(new ModelResourceLocation(gun.getRegistryName().toString(), "inventory"), new BakedModelGun(gun, main, models));
        }
    }

    public void modelRegistry(ModelRegistryEvent event) {
        for (GunItem gun : GunItem.ALL_GUNS_LIST) {
            for (EnumAttachmentType type : EnumAttachmentType.RENDER_ORDER) {
                ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/" + type.getDefaultResource(), "inventory"));
                for (int i = 0; i < gun.getAmmountForSlot(type); ++i) {
                    AttachmentItem attachment = gun.getAttachment(type, i);
                    ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
        }
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            GunItem gun;
            ItemStack itemStack;
            int i;
            PlayerEntity entityPlayer = ClientProxy.getClientPlayer();
            if (entityPlayer == null) {
                return;
            }
            for (i = 0; i < GunCusUtility.HANDS.length; ++i) {
                Hand hand = GunCusUtility.HANDS[i];
                if (locked[i] && !ClientProxy.isShooting()) {
                    ClientProxy.locked[i] = false;
                }
                if (shootTime[i] > 0) {
                    int n = i;
                    shootTime[n] = shootTime[n] - 1;
                }
                if (!((itemStack = entityPlayer.func_184586_b(hand)).func_77973_b() instanceof GunItem)) continue;
                gun = (GunItem)itemStack.func_77973_b();
                if (gun.getNBTIsReloading(itemStack)) {
                    ClientProxy.shootTime[i] = 1;
                    continue;
                }
                if (hand != Hand.MAIN_HAND || entityPlayer.field_71071_by.field_70461_c == prevSelectedMain) continue;
                int n = i;
                shootTime[n] = shootTime[n] + gun.calcCurrentSwitchTime(gun.getCurrentAttachments(itemStack));
            }
            prevSelectedMain = entityPlayer.field_71071_by.field_70461_c;
            if (inaccuracyTime > 0) {
                --inaccuracyTime;
            }
            if (ClientProxy.isShooting() && (entityPlayer.func_184614_ca().func_77973_b() instanceof GunItem || entityPlayer.func_184592_cb().func_77973_b() instanceof GunItem)) {
                boolean aiming = false;
                if (ClientProxy.isAiming() && !entityPlayer.func_70051_ag() && entityPlayer.func_184614_ca().func_77973_b() instanceof GunItem && entityPlayer.func_184592_cb().func_190926_b() && (gun = (GunItem)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    Optic optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                    aiming = optic.canAim();
                }
                i = 0;
                int handsInt = 0;
                for (i = 0; i < GunCusUtility.HANDS.length; ++i) {
                    if (locked[i] || !(entityPlayer.func_184586_b(GunCusUtility.HANDS[i]).func_77973_b() instanceof GunItem) || shootTime[i] > 0) continue;
                    handsInt += i + 1;
                    gun = (GunItem)entityPlayer.func_184586_b(GunCusUtility.HANDS[i]).func_77973_b();
                    if (gun.getCurrentFireMode(entityPlayer.func_184586_b(GunCusUtility.HANDS[i])) == GunItem.EnumFireMode.FULL_AUTO) continue;
                    ClientProxy.locked[i] = true;
                }
                if (handsInt > 0) {
                    GunCus.channel.sendToServer((Object)new ShootMessage(aiming, inaccuracyTime, handsInt));
                    GunItem.tryShoot(entityPlayer, aiming, inaccuracyTime, GunCusUtility.intToHands(handsInt));
                }
            }
            for (ShuffleItemGroup group : ShuffleItemGroup.GROUPS_LIST) {
                group.tick();
            }
        }
    }

    public static void drawDrawFullscreenImage(MatrixStack ms, ResourceLocation rl, int texWidth, int texHeight, MainWindow sr) {
        ms.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        ClientProxy.getMC().func_110434_K().func_110577_a(rl);
        int x = sr.func_198107_o();
        int y = sr.func_198087_p();
        AbstractGui.func_238466_a_((MatrixStack)ms, (int)((x - texWidth) / 2), (int)((y - texHeight) / 2), (int)texWidth, (int)texHeight, (float)0.0f, (float)0.0f, (int)texWidth, (int)texHeight, (int)texWidth, (int)texHeight);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        ms.func_227865_b_();
    }

    public static Minecraft getMC() {
        return Minecraft.func_71410_x();
    }

    @Nullable
    public static PlayerEntity getClientPlayer() {
        return ClientProxy.getMC().field_71439_g;
    }

    public static FontRenderer getFontRenderer() {
        return ClientProxy.getMC().field_71466_p;
    }

    public static boolean isAiming() {
        return ClientProxy.getMC().field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean isShooting() {
        return ClientProxy.getMC().field_71474_y.field_74312_F.func_151470_d();
    }

    public static void renderDisabledRect(MatrixStack ms, float x, float y, float w, float h) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        ClientProxy.drawRect(ms, x, y, w, h, 0.0f, 0.0f, 0.0f, 0.5f);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void drawRect(MatrixStack ms, float x, float y, float w, float h, float r, float g, float b, float a) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_227740_m_();
        GlStateManager.func_227621_I_();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        Matrix4f m = ms.func_227866_c_().func_227870_a_();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_227888_a_(m, x, y + h, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(m, x + w, y + h, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(m, x + w, y, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(m, x, y, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227619_H_();
        GlStateManager.func_227737_l_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

