/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.cas_ual_ty.guncus.client.ClientProxy;
import net.minecraft.client.MainWindow;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HitmarkerRenderer {
    public static final ResourceLocation HITMARKER_TEXTURE = new ResourceLocation("guncus", "textures/gui/hitmarker.png");
    private static final int HITMARKER_RESET = 4;
    private static int hitmarkerTick = 0;

    public static void addHitmarker() {
        hitmarkerTick = 4;
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ClientProxy.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null && hitmarkerTick > 0) {
            HitmarkerRenderer.drawHitmarker(event.getMatrixStack(), event.getWindow());
        }
    }

    private static void drawHitmarker(MatrixStack ms, MainWindow sr) {
        ClientProxy.drawDrawFullscreenImage(ms, HITMARKER_TEXTURE, 1024, 256, sr);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && hitmarkerTick > 0) {
            --hitmarkerTick;
        }
    }
}

