/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.cas_ual_ty.guncus.client.ClientProxy;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.Accessory;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import net.minecraft.client.MainWindow;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SightRenderer {
    @SubscribeEvent
    public void fovUpdate(FOVUpdateEvent event) {
        PlayerEntity entityPlayer = ClientProxy.getClientPlayer();
        if (entityPlayer != null && ClientProxy.isAiming() && !entityPlayer.func_70051_ag()) {
            Optic optic = null;
            float modifier = 1.0f;
            float extra = 0.0f;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof GunItem && entityPlayer.func_184592_cb().func_190926_b()) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                GunItem gun = (GunItem)itemStack.func_77973_b();
                if (gun.getNBTCanAimGun(itemStack)) {
                    optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                }
                if (optic != null && gun.isNBTAccessoryTurnedOn(itemStack) && !gun.getAttachment(itemStack, EnumAttachmentType.ACCESSORY).isDefault()) {
                    Accessory accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                    if (optic.isCompatibleWithMagnifiers()) {
                        modifier = accessory.getZoomModifier();
                    }
                    if (optic.isCompatibleWithExtraZoom()) {
                        extra = accessory.getExtraZoom();
                    }
                }
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                optic = (Optic)itemStack.func_77973_b();
            }
            if (optic != null && optic.canAim()) {
                event.setNewfov(SightRenderer.calculateFov(optic.getZoom() * modifier + 0.1f + extra, event.getFov()));
            }
        }
    }

    private static float calculateFov(float zoom, float fov) {
        return (float)Math.atan(Math.tan(fov) / (double)zoom);
    }

    @SubscribeEvent
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ClientProxy.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null) {
            Optic optic = null;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof GunItem || entityPlayer.func_184592_cb().func_77973_b() instanceof GunItem) {
                ItemStack itemStack;
                GunItem gun;
                if (entityPlayer.func_184592_cb().func_190926_b() && (gun = (GunItem)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                }
                event.setCanceled(true);
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                optic = (Optic)entityPlayer.func_184614_ca().func_77973_b();
            }
            if (optic != null && optic.getOverlay() != null && !entityPlayer.func_70051_ag() && ClientProxy.isAiming()) {
                SightRenderer.drawSight(event.getMatrixStack(), optic, event.getWindow());
                if (!event.isCanceled()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    private static void drawSight(MatrixStack ms, Optic optic, MainWindow sr) {
        ClientProxy.drawDrawFullscreenImage(ms, optic.getOverlay(), 1024, 256, sr);
    }
}

