/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.container;

import de.cas_ual_ty.guncus.container.AttachmentSlot;
import de.cas_ual_ty.guncus.container.GunSlot;
import de.cas_ual_ty.guncus.item.AttachmentItem;
import de.cas_ual_ty.guncus.item.GunItem;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.registries.GunCusBlocks;
import de.cas_ual_ty.guncus.registries.GunCusContainerTypes;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GunTableContainer
extends Container {
    public final CraftingInventory craftMatrix = new CraftingInventory((Container)this, 3, 3);
    public final GunSlot gunSlot;
    public final PlayerEntity player;
    public final AttachmentSlot[] attachmentSlots = new AttachmentSlot[EnumAttachmentType.LENGTH];
    protected BlockPos pos = null;
    protected IWorldPosCallable worldPosCallable;
    private boolean wasGunIn = false;
    private boolean wasChanging = false;

    public GunTableContainer(int windowId, PlayerInventory playerInv) {
        super(GunCusContainerTypes.GUN_TABLE, windowId);
        this.player = playerInv.field_70458_d;
        int attachmentsX = 62;
        int attachmentsY = 17;
        boolean gunSlotX = true;
        boolean gunSlotY = true;
        this.gunSlot = new GunSlot((IInventory)this.craftMatrix, EnumAttachmentType.LENGTH, 80, 35, this.player);
        this.func_75146_a(this.gunSlot);
        for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
            AttachmentSlot attachmentSlot = new AttachmentSlot((IInventory)this.craftMatrix, type.getSlot(), 62 + type.getX() * 18, 17 + type.getY() * 18, this.gunSlot, type, this.player);
            this.attachmentSlots[type.getSlot()] = attachmentSlot;
            this.func_75146_a(attachmentSlot);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 8 + x * 18, 142));
        }
    }

    public GunTableContainer(int windowId, PlayerInventory playerInv, BlockPos pos) {
        this(windowId, playerInv);
        this.pos = pos;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)this.player.field_70170_p, (BlockPos)this.pos);
    }

    public GunTableContainer(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(windowId, playerInv, extraData.func_179259_c());
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.pos == null || Container.func_216963_a((IWorldPosCallable)this.worldPosCallable, (PlayerEntity)playerIn, (Block)GunCusBlocks.GUN_TABLE);
    }

    public void func_75130_a(IInventory inventoryIn) {
        if (inventoryIn == this.craftMatrix) {
            if (this.wasChanging) {
                return;
            }
            this.wasChanging = true;
            if (this.gunSlot.func_75216_d()) {
                if (!this.wasGunIn) {
                    GunItem gun = (GunItem)this.gunSlot.func_75211_c().func_77973_b();
                    for (AttachmentSlot slot : this.attachmentSlots) {
                        slot.func_75215_d(gun.getAttachmentItemStack(this.gunSlot.func_75211_c(), slot.type));
                    }
                } else {
                    GunItem gun = (GunItem)this.gunSlot.func_75211_c().func_77973_b();
                    for (AttachmentSlot slot : this.attachmentSlots) {
                        gun.setAttachment(this.gunSlot.func_75211_c(), slot.getAttachment());
                    }
                }
            } else {
                for (AttachmentSlot slot : this.attachmentSlots) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            }
            this.wasChanging = false;
        }
        this.wasGunIn = this.gunSlot.func_75216_d();
        super.func_75130_a(inventoryIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack itemStack = slot.func_75211_c();
        if (index >= 9) {
            AttachmentItem attachment;
            if (itemStack.func_77973_b() instanceof GunItem) {
                if (this.gunSlot.func_75214_a(itemStack) && !this.gunSlot.func_75216_d()) {
                    this.gunSlot.func_75215_d(itemStack.func_77946_l());
                    itemStack.func_190918_g(1);
                }
            } else if (itemStack.func_77973_b() instanceof AttachmentItem && this.attachmentSlots[(attachment = (AttachmentItem)itemStack.func_77973_b()).getSlot()].func_75214_a(itemStack) && !this.attachmentSlots[attachment.getSlot()].func_75216_d()) {
                this.attachmentSlots[attachment.getSlot()].func_75215_d(new ItemStack((IItemProvider)attachment));
                itemStack.func_190918_g(1);
            }
        } else if (playerIn.field_71071_by.func_70441_a(itemStack)) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        if (this.gunSlot.func_75216_d()) {
            playerIn.func_71019_a(this.gunSlot.func_75211_c(), false);
        }
        super.func_75134_a(playerIn);
    }
}

