/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.container;

import de.cas_ual_ty.guncus.item.MakerItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MakerContainer
extends Container {
    public final PlayerEntity player;
    protected BlockPos pos;
    protected IWorldPosCallable worldPosCallable;
    private int selectedItemIndex;
    public final Inventory inventory;
    public final ArrayList<Slot> materialsSlots;
    public final Slot selectedItemSlot;

    public MakerContainer(ContainerType<?> type, int windowId, PlayerInventory playerInv, BlockPos pos) {
        super(type, windowId);
        this.player = playerInv.field_70458_d;
        this.pos = pos;
        this.worldPosCallable = IWorldPosCallable.func_221488_a((World)this.player.field_70170_p, (BlockPos)this.pos);
        this.inventory = new Inventory(10);
        this.materialsSlots = new ArrayList(9);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.materialsSlots.add(new Slot((IInventory)this.inventory, x + y * 3, 30 + 18 * x, 17 + 18 * y){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }

                    public boolean func_82869_a(PlayerEntity playerIn) {
                        return false;
                    }
                });
            }
        }
        this.selectedItemSlot = new Slot((IInventory)this.inventory, 9, 124, 35){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return false;
            }
        };
        for (Slot s : this.materialsSlots) {
            this.func_75146_a(s);
        }
        this.func_75146_a(this.selectedItemSlot);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInv, x, 8 + x * 18, 142));
        }
        this.selectedItemIndex = -1;
        this.nextItem();
    }

    public MakerContainer(ContainerType<?> type, int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(type, windowId, playerInv, extraData.func_179259_c());
    }

    public abstract List<MakerItem> getItemsList();

    public void nextItem() {
        if (this.getItemsList().isEmpty()) {
            return;
        }
        ++this.selectedItemIndex;
        if (this.selectedItemIndex >= this.getItemsList().size()) {
            this.selectedItemIndex = 0;
        }
        MakerItem item = this.getItemsList().get(this.selectedItemIndex);
        this.selectedItemSlot.func_75215_d(new ItemStack((IItemProvider)item));
        this.populate();
    }

    public void prevItem() {
        if (this.getItemsList().isEmpty()) {
            return;
        }
        --this.selectedItemIndex;
        if (this.selectedItemIndex < 0) {
            this.selectedItemIndex = this.getItemsList().size() - 1;
        }
        MakerItem item = this.getItemsList().get(this.selectedItemIndex);
        this.selectedItemSlot.func_75215_d(new ItemStack((IItemProvider)item));
        this.populate();
    }

    public void populate() {
        if (!this.selectedItemSlot.func_75216_d() || !(this.selectedItemSlot.func_75211_c().func_77973_b() instanceof MakerItem)) {
            return;
        }
        MakerItem item = (MakerItem)this.selectedItemSlot.func_75211_c().func_77973_b();
        List<ItemStack> materials = item.getMakerMaterials();
        this.selectedItemSlot.func_75215_d(new ItemStack((IItemProvider)item));
        for (Slot s : this.materialsSlots) {
            s.func_75215_d(ItemStack.field_190927_a);
        }
        for (int y = 0; y < 3; ++y) {
            int index;
            for (int x = 0; x < 3 && (index = x + y * 3) < this.materialsSlots.size() && index < materials.size(); ++x) {
                this.materialsSlots.get(index).func_75215_d(materials.get(index));
            }
        }
        this.func_75142_b();
    }

    public void create() {
        if (!this.selectedItemSlot.func_75216_d() || !(this.selectedItemSlot.func_75211_c().func_77973_b() instanceof MakerItem)) {
            return;
        }
        MakerItem item = (MakerItem)this.selectedItemSlot.func_75211_c().func_77973_b();
        List<ItemStack> materials = item.getMakerMaterials();
        if (!this.player.func_184812_l_()) {
            for (ItemStack material : materials) {
                if (this.playerHasMaterial(material, false)) continue;
                return;
            }
            for (ItemStack material : materials) {
                if (this.playerHasMaterial(material, true)) continue;
                return;
            }
        }
        this.player.func_71019_a(new ItemStack((IItemProvider)item, item.getMakerOutputAmount()), false);
    }

    public boolean playerHasMaterial(ItemStack material, boolean consume) {
        PlayerInventory playerInv = this.player.field_71071_by;
        for (int i = 0; i < playerInv.func_70302_i_(); ++i) {
            ItemStack itemStack = playerInv.func_70301_a(i);
            if (!this.itemFitsMaterial(itemStack, material)) continue;
            if (consume) {
                itemStack.func_190918_g(material.func_190916_E());
            }
            return true;
        }
        return false;
    }

    protected boolean itemFitsMaterial(ItemStack itemStack, ItemStack material) {
        return itemStack.func_77973_b() == material.func_77973_b() && itemStack.func_190916_E() >= material.func_190916_E();
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
    }
}

