/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.entity;

import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.item.BulletItem;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletEntity
extends ThrowableEntity {
    public static final float BASE_SPEED = 20.0f;
    public static final int TICKS = 1;
    protected static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(BulletEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(BulletEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected BulletItem bullet = null;

    public BulletEntity(EntityType<BulletEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public BulletEntity(EntityType<BulletEntity> type, LivingEntity livingEntityIn, World worldIn, BulletItem bullet) {
        super(type, livingEntityIn, worldIn);
        this.bullet = bullet;
    }

    public BulletEntity setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public BulletEntity setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public void func_70071_h_() {
        this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
        for (int i = 0; i < 1; ++i) {
            super.func_70071_h_();
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
        this.spawnParticles();
        if (this.field_70173_aa >= 20) {
            this.func_70106_y();
        }
    }

    public void spawnParticles() {
        Vector3d mot = this.func_213322_ci();
        Vector3d pos = this.func_213303_ch();
        double d1 = mot.field_72450_a;
        double d2 = mot.field_72448_b;
        double d0 = mot.field_72449_c;
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, pos.field_72450_a + d1 * (double)i / 4.0, pos.field_72448_b + d2 * (double)i / 4.0, pos.field_72449_c + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, pos.field_72450_a + d1 * (double)i / 4.0, pos.field_72448_b + d2 * (double)i / 4.0, pos.field_72449_c + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, pos.field_72450_a + d1 * (double)i / 4.0, pos.field_72448_b + d2 * (double)i / 4.0, pos.field_72449_c + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, pos.field_72450_a + d1 * (double)i / 4.0, pos.field_72448_b + d2 * (double)i / 4.0, pos.field_72449_c + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult hit = (EntityRayTraceResult)result;
            if (hit.func_216348_a() == this.func_234616_v_() && this.field_70173_aa <= 5) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && hit.func_216348_a() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)hit.func_216348_a();
                if (this.bullet != null && this.bullet.getOnHit() != null) {
                    this.bullet.getOnHit().accept(entity);
                }
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)((LivingEntity)this.func_234616_v_())), this.getBulletDamage());
                if (this.func_234616_v_() instanceof PlayerEntity) {
                    GunCus.proxy.addHitmarker((PlayerEntity)this.func_234616_v_());
                }
            }
        }
        this.func_70106_y();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(4.0f));
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(1.0f));
    }

    protected float func_70185_h() {
        return super.func_70185_h() * this.getBulletGravity() / 1.0f;
    }

    protected float getBulletDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    protected float getBulletGravity() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("bulletType")) {
            this.bullet = (BulletItem)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i("bulletType")));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.bullet != null) {
            compound.func_74778_a("bulletType", this.bullet.getRegistryName().toString());
        }
    }
}

