/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item;

import de.cas_ual_ty.guncus.item.MakerItem;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AttachmentItem
extends MakerItem {
    public static final List<AttachmentItem> ALL_ATTACHMENTS_LIST = new ArrayList<AttachmentItem>();
    protected float zoomModifier = 1.0f;
    protected float extraZoom = 0.0f;
    protected float extraDamage = 0.0f;
    protected float driftModifier = 1.0f;
    protected float speedModifier = 1.0f;
    protected float spreadModifierVertical = 1.0f;
    protected float spreadModifierHorizontal = 1.0f;
    protected float inaccuracyModifier = 1.0f;
    protected float inaccuracyModifierMoving = 1.0f;
    protected float inaccuracyModifierStill = 1.0f;

    public AttachmentItem(Item.Properties properties, int craftAmount, ItemStack ... materials) {
        super(properties, craftAmount, materials);
        ALL_ATTACHMENTS_LIST.add(this);
    }

    public AttachmentItem(Item.Properties properties, ItemStack ... materials) {
        this(properties, 1, materials);
    }

    public AttachmentItem setDefaultTradeable() {
        new RandomTradeBuilder(2, 50, 0.05f).setEmeraldPriceFor(16, this).registerLevel(2);
        return this;
    }

    public abstract EnumAttachmentType getType();

    public float getZoomModifier() {
        return this.zoomModifier;
    }

    public float getExtraZoom() {
        return this.extraZoom;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public float getDriftModifier() {
        return this.driftModifier;
    }

    public float getSpeedModifier() {
        return this.speedModifier;
    }

    public float getSpreadModifierVertical() {
        return this.spreadModifierVertical;
    }

    public float getSpreadModifierHorizontal() {
        return this.spreadModifierHorizontal;
    }

    public float getInaccuracyModifier() {
        return this.inaccuracyModifier;
    }

    public float getInaccuracyModifierMoving() {
        return this.inaccuracyModifierMoving;
    }

    public float getInaccuracyModifierStill() {
        return this.inaccuracyModifierStill;
    }

    public AttachmentItem setZoomModifier(float zoomModifier) {
        this.zoomModifier = zoomModifier;
        return this;
    }

    public AttachmentItem setExtraZoom(float extraZoom) {
        this.extraZoom = extraZoom;
        return this;
    }

    public AttachmentItem setExtraDamage(float extraDamage) {
        this.extraDamage = extraDamage;
        return this;
    }

    public AttachmentItem setDriftModifier(float driftModifier) {
        this.driftModifier = driftModifier;
        return this;
    }

    public AttachmentItem setSpeedModifier(float speedModifier) {
        this.speedModifier = speedModifier;
        return this;
    }

    public AttachmentItem setSpreadModifierVertical(float spreadModifierVertical) {
        this.spreadModifierVertical = spreadModifierVertical;
        return this;
    }

    public AttachmentItem setSpreadModifierHorizontal(float spreadModifierHorizontal) {
        this.spreadModifierHorizontal = spreadModifierHorizontal;
        return this;
    }

    public AttachmentItem setInaccuracyModifier(float inaccuracyModifier) {
        this.inaccuracyModifier = inaccuracyModifier;
        return this;
    }

    public AttachmentItem setInaccuracyModifierMoving(float inaccuracyModifierMoving) {
        this.inaccuracyModifierMoving = inaccuracyModifierMoving;
        return this;
    }

    public AttachmentItem setInaccuracyModifierStill(float inaccuracyModifierStill) {
        this.inaccuracyModifierStill = inaccuracyModifierStill;
        return this;
    }

    public final AttachmentItem getDefaultOfSameSlot() {
        return EnumAttachmentType.getSlot(this.getSlot()).getDefault();
    }

    public boolean isDefault() {
        return this == this.getType().getDefault();
    }

    public int getSlot() {
        return this.getType().getSlot();
    }

    public String getAttachmentRegistryName() {
        return this.isDefault() ? "" : this.getRegistryName().toString();
    }

    public String func_77658_a() {
        return this.isDefault() ? "item.guncus." + this.getType().getKey() + "_default" : super.func_77658_a();
    }

    public String getStringSuffix() {
        return this.isDefault() ? "" : "_" + this.getRegistryName().func_110623_a().toString();
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)this.getType().getDisplayName().func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW)).func_240702_b_(" ").func_230529_a_((ITextComponent)AttachmentItem.getAttachmentTranslated(false).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_GRAY))));
    }

    public IFormattableTextComponent getInformationString() {
        return new TranslationTextComponent(this.func_77658_a()).func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW));
    }

    public static IFormattableTextComponent getAttachmentTranslated(boolean plural) {
        return new TranslationTextComponent("local.guncus.attachment" + (plural ? "s" : ""));
    }

    public static AttachmentItem[][] buildDefaultArray() {
        AttachmentItem[][] attachments = new AttachmentItem[EnumAttachmentType.LENGTH][];
        for (int i = 0; i < attachments.length; ++i) {
            attachments[i] = new AttachmentItem[]{EnumAttachmentType.getSlot(i).getDefault()};
        }
        return attachments;
    }
}

