/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item;

import de.cas_ual_ty.guncus.item.MakerItem;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BulletItem
extends MakerItem {
    public static final List<BulletItem> ALL_BULLETS_LIST = new ArrayList<BulletItem>();
    public static final List<MakerItem> MAKER_BULLETS_LIST = new ArrayList<MakerItem>();
    protected float extraDamage = 0.0f;
    protected float gravity = 1.0f;
    protected float bulletSpeedModifier = 1.0f;
    protected float spreadModifier = 1.0f;
    protected int projectileAmount = 1;
    protected Consumer<LivingEntity> onHit = null;

    public BulletItem(Item.Properties properties, int craftAmount, ItemStack ... materials) {
        super(properties, craftAmount, materials);
        if (craftAmount > 0 && materials.length > 0) {
            MAKER_BULLETS_LIST.add(this);
        }
        ALL_BULLETS_LIST.add(this);
    }

    public BulletItem(Item.Properties properties, int iron, int gunpowder, int craftAmt) {
        this(properties, craftAmt, new ItemStack((IItemProvider)Items.field_151042_j, iron), new ItemStack((IItemProvider)Items.field_151016_H, gunpowder));
    }

    public BulletItem setDefaultTradeable(int amt) {
        new RandomTradeBuilder(3, 25, 0.05f).setEmeraldPriceFor(1, this, amt).registerLevel(1);
        return this;
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public float getGravity() {
        return this.gravity;
    }

    public float getBulletSpeedModifier() {
        return this.bulletSpeedModifier;
    }

    public float getSpreadModifier() {
        return this.spreadModifier;
    }

    public int getProjectileAmount() {
        return this.projectileAmount;
    }

    public Consumer<LivingEntity> getOnHit() {
        return this.onHit;
    }

    public BulletItem setDamage(float damage) {
        this.extraDamage = damage;
        return this;
    }

    public BulletItem setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public BulletItem setBulletSpeedModifier(float bulletSpeedModifier) {
        this.bulletSpeedModifier = bulletSpeedModifier;
        return this;
    }

    public BulletItem setSpreadModifier(float spreadModifier) {
        this.spreadModifier = spreadModifier;
        return this;
    }

    public BulletItem setProjectileAmount(int projectileAmount) {
        this.projectileAmount = projectileAmount;
        return this;
    }

    public BulletItem setOnHit(Consumer<LivingEntity> onHit) {
        this.onHit = onHit;
        return this;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("local.guncus.bullet").func_230530_a_(Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW)));
    }
}

